/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.publisher;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ReportGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.LastBuildsFile;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatisticsReportPublisher
implements StatisticsSupport {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsReportPublisher.class);

    protected abstract ReportCategory getCategory();

    public boolean isApplicable(Build build) {
        if (this.getCategory() == null) {
            return false;
        }
        ReportGenerator[] generators = this.getCategory().getGenerators(GeneratorStage.STATISTICS);
        File categoryDir = this.getCategory().getCategoryDirOfBuild(build);
        return generators.length > 0 && categoryDir.exists();
    }

    protected String[] getBuildReportSets(Build build) {
        return this.getCategory().getReportSetsOfBuild(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupStatistics(Configuration configuration) {
        logger.info("Cleaning up statistics data for report '" + this.getCategory().getName() + "', configuration: " + configuration.getId());
        File statsReportDir = this.getCategory().getCategoryDirOfStats(configuration);
        Lock lock = LockUtils.lockForWrite((File)statsReportDir);
        try {
            FileUtils.deleteDir((File)statsReportDir);
        }
        finally {
            lock.unlock();
        }
    }

    public String getStatisticsName() {
        return this.getCategory().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStatistics(Build build) {
        if (!this.isApplicable(build)) {
            return;
        }
        ReportCategory category = this.getCategory();
        String[] reportsets = this.getBuildReportSets(build);
        if (reportsets.length == 0) {
            logger.info("No statistics data for '" + category.getName() + "'.");
            return;
        }
        File statsDir = category.createCategoryDirOfStats(build.getConfiguration());
        Lock lock = LockUtils.lock((File)statsDir);
        try {
            GeneratorContext context = GeneratorContext.getContext();
            for (String reportset : reportsets) {
                context.clear();
                context.setReportCategory(category);
                context.setReportSet(reportset);
                context.setCurrentBuild(build);
                context.setSourceDir(this.getSourceDir(build, reportset));
                context.setGenerateStage(GeneratorStage.STATISTICS);
                context.setLocale(ReportHelper.getLocale());
                File workingDir = category.getReportDirOfStats(build.getConfiguration(), reportset);
                if (!workingDir.exists()) {
                    FileUtils.createDir((File)workingDir);
                }
                context.setWorkingDir(workingDir);
                this.beforePublish(build);
                this.doPublish(build);
                this.afterPublish(build);
            }
        }
        finally {
            lock.unlock();
            GeneratorContext.setContext(null);
            logger.info("Finished collecting statistics data for report '" + category.getName() + "' [configuration: " + build.getConfiguration().getId() + ", build: " + build.getId() + "]");
        }
    }

    protected File getSourceDir(Build build, String reportset) {
        return this.getCategory().getReportDirOfBuild(build, reportset);
    }

    protected void doPublish(Build build) {
        ReportGenerator[] generators;
        for (ReportGenerator generator : generators = this.getCategory().getGenerators(GeneratorStage.STATISTICS)) {
            generator.generate();
        }
    }

    protected void beforePublish(Build build) {
    }

    protected void afterPublish(Build build) {
        GeneratorContext context = GeneratorContext.getContext();
        File workingDir = context.getWorkingDir();
        LastBuildsFile lbf = new LastBuildsFile(workingDir);
        lbf.load();
        lbf.add(Context.getBuild());
        lbf.save();
    }

    public String toString() {
        return this.getCategory().getName();
    }
}

