/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.publisher;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.AbstractPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.UnProcessedReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ReportGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportOverviewSetting;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class BuildReportPublisher
extends AbstractPublisher {
    private static final long serialVersionUID = 1L;
    protected String stepFailureCondition = "false";
    protected String stepFailureMessage;

    protected abstract ReportCategory getCategory();

    protected abstract void saveStatsReport();

    protected abstract String getStatsReportName();

    @Override
    protected String getPublisherName() {
        return this.getCategory().getName();
    }

    protected void checkStepStatus() {
        if (this.isStepFailed()) {
            String failureMessage = this.getStepFailureMessage();
            if (StringUtils.isBlank((String)failureMessage)) {
                failureMessage = "Step failure condition is matched";
            }
            throw new QuickbuildException(failureMessage);
        }
    }

    @Override
    protected void onNotApplicable() {
        this.checkStepStatus();
    }

    @Override
    public void onBeforePublish() {
        super.onBeforePublish();
        ReportCategory category = this.getCategory();
        if (category.hasUnProcessedReport()) {
            UnProcessedReport malFormedReport = new UnProcessedReport();
            GeneratorContext.getContext().setUnProcessedReport(malFormedReport);
        }
        category.writeVersionFile(this.getWorkingDir());
        GeneratorContext context = GeneratorContext.getContext();
        context.setReportCategory(category);
    }

    @Override
    public void onAfterPublish() {
        UnProcessedReport malFormedReport;
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = context.getReportCategory();
        File dbDir = context.getWorkingDir();
        if (category.hasUnProcessedReport() && !(malFormedReport = context.getUnProcessedReport()).isEmpty()) {
            category.saveReport(dbDir, (DataReport)malFormedReport);
        }
        this.saveStatsReport();
        category.optimizeDb(dbDir);
        this.setOverviewData();
        this.checkStepStatus();
    }

    protected DataReport getStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        ReportCategory category = this.getCategory();
        String statsReportName = this.getStatsReportName();
        File dbDir = context.getWorkingDir();
        if (dbDir == null || !dbDir.exists()) {
            return category.createReport(statsReportName);
        }
        return category.loadReport(dbDir, statsReportName, new Filter[0]);
    }

    protected boolean isStepFailed() {
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        Map context = Context.buildEvalContext((Object)((Object)this), null);
        return (Boolean)em.evaluate(this.getStepFailureCondition(), context);
    }

    protected Map<String, Object> getStats() {
        DataReport statsReport = this.getStatsReport();
        if (statsReport == null || statsReport.isEmpty()) {
            return null;
        }
        DataRow row = statsReport.getRow(0);
        return row.toMap();
    }

    protected DataReport getOverviewReport() {
        ReportCategory category = this.getCategory();
        ReportOverviewSetting overviewSetting = category.getOverviewSetting();
        if (overviewSetting == null || overviewSetting.getDataSource() == null) {
            return null;
        }
        File dbDir = GeneratorContext.getContext().getWorkingDir();
        if (!dbDir.exists()) {
            return category.createReport(overviewSetting.getDataSource().getFrom());
        }
        return category.loadReport(dbDir, overviewSetting.getDataSource());
    }

    protected String getBaseUrl() {
        return "/" + Tab.title2id((String)this.getCategory().getName());
    }

    public void setOverviewData() {
        Context.getLogger().info("Initialize overview data ...");
        Map<String, Object> stats = this.getStats();
        DataReport report = this.getOverviewReport();
        if (stats == null && report == null) {
            return;
        }
        String categoryId = this.getCategory().getId();
        Build build = Context.getBuild();
        LinkedHashMap categoryData = (LinkedHashMap)build.getReports().get(categoryId);
        if (categoryData == null) {
            categoryData = new LinkedHashMap();
            build.getReports().put(categoryId, categoryData);
        }
        String reportsetName = GeneratorContext.getContext().getReportSet();
        HashMap<String, Object> overviewData = new HashMap<String, Object>();
        overviewData.put("name", reportsetName);
        overviewData.put("baseUrl", this.getBaseUrl());
        overviewData.put("utils", ReportUtils.getInstance());
        if (report != null) {
            overviewData.put("rows", report.getRows());
        } else {
            overviewData.put("rows", Lists.newArrayList());
        }
        if (stats != null) {
            overviewData.put("stats", stats);
        } else {
            overviewData.put("stats", Collections.emptyMap());
        }
        overviewData.putAll(this.getExtraOverviewData(reportsetName));
        categoryData.put(reportsetName, overviewData);
    }

    protected Map<String, ?> getExtraOverviewData(String reportsetName) {
        return Collections.emptyMap();
    }

    @Override
    protected void transferFiles() {
        super.transferFiles();
        Class<? extends NodeJob> checksumJobClass = this.getChecksumJob();
        if (checksumJobClass == null) {
            return;
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Verifying file checksums ...");
        }
        File versionFile = new File(this.getWorkingDir(), "category.version");
        Collection list = FileUtils.listFiles((File)this.getWorkingDir(), (String)"**/*.h2.db");
        try {
            String vchecksum = Files.hash((File)versionFile, (HashFunction)Hashing.md5()).toString();
            String dbchecksum = Files.hash((File)((File)Iterables.getFirst((Iterable)list, null)), (HashFunction)Hashing.md5()).toString();
            Grid buildGrid = (Grid)Quickbuild.getInstance(Grid.class);
            GridNode serverNode = buildGrid.getServerNode();
            serverNode.executeJob(checksumJobClass, new Serializable[]{Context.getBuild().getId(), vchecksum, dbchecksum, GeneratorContext.getContext().getReportSet()});
        }
        catch (IOException e) {
            throw new QuickbuildException("Verify file checksum failed. Maybe there are some problems occurred while transferring files from agent to server.", (Throwable)e);
        }
    }

    protected Class<? extends NodeJob> getChecksumJob() {
        return null;
    }

    @Override
    protected String getBuildReportDir() {
        return "/reports/" + this.getCategory().getId();
    }

    @Override
    protected ReportGenerator[] getGenerators() {
        return this.getCategory().getGenerators(GeneratorStage.BUILD);
    }

    @Editable(order=1000, description="The step failure condition is to determin whether this step will be failed or not. If the evaluated result is <strong>true</strong>, QuickBuild will fail this step and also set the whole build status to fail, otherwise, the step will be successful.")
    @Expressions(value={"I don't care", "false"})
    @NotEmpty
    @Multiline
    @ScriptApi(value="Get step failure condition. A <strong>Boolean</strong> type expression string.")
    @Scriptable
    public String getStepFailureCondition() {
        return this.stepFailureCondition;
    }

    public void setStepFailureCondition(String stepFailureCondition) {
        this.stepFailureCondition = stepFailureCondition;
    }

    @Editable(order=1100, description="The step failure message is to display a failure message in build dashboard and build log when step failure condition is matched.")
    @Multiline
    @ScriptApi(value="Get step failure message. If the failure message is not set, the default message will be used.")
    @Scriptable
    public String getStepFailureMessage() {
        return this.stepFailureMessage;
    }

    public void setStepFailureMessage(String stepFailureMessage) {
        this.stepFailureMessage = stepFailureMessage;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("pluginClazz");
        if (element != null) {
            element.detach();
        }
    }

    public static abstract class ChecksumJob
    implements NodeJob {
        protected abstract ReportCategory getCategory();

        public Serializable execute(Serializable ... params) {
            Preconditions.checkArgument((params.length == 4 ? 1 : 0) != 0);
            Long buildId = (Long)params[0];
            String vchecksum = (String)((Object)params[1]);
            String dbchecksum = (String)((Object)params[2]);
            String reportset = (String)((Object)params[3]);
            if (Strings.isNullOrEmpty((String)reportset)) {
                reportset = "DEFAULT";
            }
            Build build = (Build)BuildManager.instance.get(buildId);
            ReportCategory category = this.getCategory();
            File dir = new File(build.getPublishDir(), "reports/" + category.getId());
            File versionFile = new File(dir, "category.version");
            File dbFile = new File(dir, reportset + "/" + category.getId() + ".h2.db");
            Preconditions.checkState((boolean)versionFile.exists());
            Preconditions.checkState((boolean)dbFile.exists());
            try {
                String vchecksum2 = Files.hash((File)versionFile, (HashFunction)Hashing.md5()).toString();
                String dbchecksum2 = Files.hash((File)dbFile, (HashFunction)Hashing.md5()).toString();
                if (Context.getLogger().isDebugEnabled()) {
                    Context.getLogger().debug(String.format("Job params: [%d, %s, %s], checksums: [%s, %s]", buildId, vchecksum, dbchecksum, vchecksum2, dbchecksum2));
                }
                if (Objects.equal((Object)vchecksum, (Object)vchecksum2) && Objects.equal((Object)dbchecksum, (Object)dbchecksum2)) {
                    return null;
                }
                throw new QuickbuildException(String.format("Verifying file checksums failed! Category: %s, Report set: %s, category.version checksum: [%s, %s], db checksum: %s, %s]", category.getId(), reportset, vchecksum, vchecksum2, dbchecksum, dbchecksum2));
            }
            catch (IOException e) {
                throw new QuickbuildException("Verifying file checksums failed.", (Throwable)e);
            }
        }
    }
}

