/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.publisher;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ReportGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.setting.step.executecondition.AlwaysExecute;
import com.pmease.quickbuild.setting.step.executecondition.ExecuteCondition;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.validation.validator.NameValidator;
import java.io.File;
import java.util.Collection;
import java.util.Stack;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class AbstractPublisher
extends Step {
    private static final long serialVersionUID = 1L;
    private String reportsetName;
    private String srcPath;
    private String filePattern;
    private transient File workingDir;

    public AbstractPublisher() {
        this.setExecuteCondition((ExecuteCondition)new AlwaysExecute());
    }

    @Editable(order=750, name="Source Directory", description="Specify the directory under which to search xml files containing report data. A non-absolute path is considered to be relative to current workspace directory . If left empty, the workspace directory itself will be used.")
    @ScriptApi(value="Get source path under which to search xml files containing report data. Null will be returned if search under the workspace.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=800, name="Files to Process", description="Specify xml files to be processed. Path specified here is relative to source directory specified above, for example <b>reports/junit/*.xml</b> stands for all the files with <b>.xml</b> suffix under the <b>reports/junit</b> sub directory relative to the source directory. Refer to <a href=\"$docroot/File+Pattern+Reference\">File Pattern Reference</a> for details of valid file patterns.")
    @NotEmpty
    @ScriptApi(value="Get report files or patterns")
    @Scriptable
    public String getFilePattern() {
        if (this.filePattern == null) {
            return "";
        }
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    @Editable(order=1300, name="Report Set Name", description="The report set name here is used when you need aggregate your reports. For example, when you run tests in different platforms,  such as Windows, Linux, Solaris, you can define several publish steps to collect the reports for each of them, you may define a step <strong>Publish Tests On Windows</strong> and specify the report set name here as <strong>On Windows</strong>, and define another publish step as <strong>Publish Tests on Linux</strong> with the report set name here as <strong>On Linux</strong>, etc.  Quickbulid will collect those reports seperately and aggregate them together on Dashboard, report tab and statistics page.<br/> Make sure your report set name is unique in one configuration for one kind of publish report step. One and only one can be empty  fot the name. For example, if serveral steps for publish junit reports are defined, one can be empty for the report set name, this will be recognized as 'default' report set in Quickbuild, and others should have different report set names. The report set names can be the same for different kinds of publish step. For example, 'With Tomcat' for Publish JUnit Step, and 'With Tomcat' for  Publish TestNG step, the definitions are legal in Quickbuild.")
    @ScriptApi(value="Name of the report set.")
    @Scriptable
    public String getReportsetName() {
        return this.reportsetName;
    }

    public void setReportsetName(String reportName) {
        this.reportsetName = reportName;
    }

    protected abstract ReportGenerator[] getGenerators();

    protected abstract String getBuildReportDir();

    protected void onNotApplicable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.isApplicable()) {
            this.onNotApplicable();
            return;
        }
        this.workingDir = FileUtils.createTempDir((String)"abstractpublisher");
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Working directory [" + this.workingDir + "] created.");
        }
        try {
            this.onBeforePublish();
            this.doPublish();
            this.onAfterPublish();
        }
        finally {
            try {
                if (this.needTransfer()) {
                    this.transferFiles();
                }
            }
            finally {
                GeneratorContext.getContext().clear();
                GeneratorContext.setContext(null);
                if (Context.getLogger().isDebugEnabled()) {
                    Context.getLogger().debug("Deleting working directory [" + this.workingDir + "].");
                }
                FileUtils.deleteDir((File)this.workingDir);
            }
        }
    }

    protected void doPublish() {
        ReportGenerator[] generators = this.getGenerators();
        if (generators == null || generators.length == 0) {
            Context.getLogger().warn("No report generators defined.");
            return;
        }
        for (ReportGenerator generator : generators) {
            generator.generate();
        }
    }

    protected boolean isApplicable() {
        String filePatterns = this.getFilePattern();
        File workspaceDir = Context.getBuild().getConfiguration().getWorkspaceDir().getAbsoluteFile();
        File dir = FileUtils.resolvePath((File)workspaceDir, (String)this.getSrcPath());
        if (!dir.exists()) {
            Context.getLogger().info("The report dir: " + dir + " does not exists.");
            return false;
        }
        Collection inputFiles = FileUtils.listFiles((File)dir, (String)filePatterns);
        if (inputFiles.size() == 0) {
            Context.getLogger().warn("There is no input file need publish for '" + this.getPublisherName() + "', [Dir: " + dir + ", Pattern: " + filePatterns + "]");
            return false;
        }
        return true;
    }

    protected abstract String getPublisherName();

    protected void onBeforePublish() {
        Build build = Context.getBuild();
        GeneratorContext context = GeneratorContext.getContext();
        context.setCurrentBuild(build);
        File sourceDir = FileUtils.resolvePath((File)build.getConfiguration().getWorkspaceDir(), (String)this.getSrcPath());
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Publish original reports in directory: " + sourceDir);
        }
        context.setSourceDir(sourceDir);
        String reportset = this.getReportsetName();
        if (Strings.isNullOrEmpty((String)reportset)) {
            context.setReportsetIsEmpty(true);
        } else {
            context.setReportsetIsEmpty(false);
        }
        reportset = Strings.isNullOrEmpty((String)reportset) || reportset.equalsIgnoreCase("DEFAULT") ? "DEFAULT" : reportset.trim();
        if (!NameValidator.isValid((String)reportset)) {
            throw new QuickbuildException("The report set name is invalid. Can not contain any of below characters:\n, / \\ : * ? \" < > | [ ]");
        }
        File reportWorkingDir = new File(this.workingDir, reportset);
        if (!reportWorkingDir.exists()) {
            FileUtils.createDir((File)reportWorkingDir);
        }
        context.setWorkingDir(reportWorkingDir);
        context.setReportSet(reportset);
        String workspacePath = build.getConfiguration().getWorkspaceDir().getAbsolutePath();
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Current workspace path: " + workspacePath);
        }
        context.setWorkspaceDir(workspacePath);
        String filePattern = this.getFilePattern();
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Report Files/Patterns: " + filePattern);
        }
        context.setFilePatterns(this.getFilePattern());
        context.setLocale(ReportHelper.getLocale());
        context.setGenerateStage(GeneratorStage.BUILD);
    }

    protected void onAfterPublish() {
    }

    protected String getReportPublishPattern() {
        return "**";
    }

    protected void transferFiles() {
        Grid buildGrid = (Grid)Quickbuild.getInstance(Grid.class);
        GridNode serverNode = buildGrid.getServerNode();
        GridNode localNode = ((Grid)Quickbuild.getInstance(Grid.class)).getLocalNode();
        String pattern = this.getReportPublishPattern();
        String srcDir = this.workingDir.getAbsolutePath();
        String destDir = Quickbuild.getServerService().getBuildPublishDir(Context.getBuild().getId()) + this.getBuildReportDir();
        buildGrid.transferFiles(localNode, srcDir, pattern, serverNode, destDir, false, null, destDir);
    }

    protected boolean needTransfer() {
        return FileUtils.containsFileWithSuffix((File)this.workingDir, (String)".h2.db");
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }

    protected static void removeElement(VersionedDocument dom, String elementName) {
        Element node = dom.getRootElement().element(elementName);
        if (node != null) {
            node.detach();
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        AbstractPublisher.removeElement(dom, "workingDir");
    }
}

