/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution.aggregation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysNewValue;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.DataRowMerger;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.time.DateUtils;

public abstract class ReportAggregator
extends Aggregation {
    private static final long serialVersionUID = 1L;
    private String reportsets;

    public abstract ReportCategory getCategory();

    protected String getAggregationOverviewReportName() {
        return "agg_overview";
    }

    protected String getAggregationStatsReportName() {
        return "agg_stats";
    }

    protected String getStatsReportName() {
        return "stats";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(Configuration configuration, Build build) {
        long start = System.currentTimeMillis();
        ReportCategory category = this.getCategory();
        String defined = this.getReportsets();
        ArrayList availables = Lists.newArrayList();
        if (defined == null) {
            availables = Lists.newArrayList((Object[])category.getReportSetsOfBuild(build));
        } else {
            String[] reportsets;
            for (String each : reportsets = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)defined), String.class)) {
                File dir = category.getReportDirOfBuild(build, each);
                if (!dir.exists()) continue;
                availables.add(each);
            }
        }
        if (availables.isEmpty()) {
            Context.getLogger().debug("No build reports need be aggregated for category " + category.getName() + ", build: " + build.getId() + ", to configuration: " + configuration.getPathName());
            return;
        }
        File aggregateDir = category.createCategoryDirOfAggregation(configuration);
        Lock lock = LockUtils.lockForWrite((File)aggregateDir);
        try {
            String reportset = this.getName();
            File workingDir = category.getReportDirOfAggregation(configuration, reportset);
            CategoryDb db = category.getCategoryDb(workingDir);
            if (!this.needAggregate(db, build)) {
                return;
            }
            this.aggregateLatest(build, workingDir, availables);
            this.aggregateStats(build, workingDir);
            category.optimizeDb(workingDir);
        }
        finally {
            lock.unlock();
        }
        Context.getLogger().info("Aggregation '" + this.getName() + "' finished in " + DataTypes.DURATION.asString(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needAggregate(CategoryDb db, Build build) {
        try {
            db.open(DbStore.Mode.READ_ONLY, "ReportAggregator::needAggregate");
            SqlBuilder query = SqlBuilder.query().select("buildId").from(this.getAggregationOverviewReportName()).where(Restrictions.eq("configurationId", build.getConfiguration().getId()));
            Long buildId = db.queryForLong(query);
            boolean bl = buildId == null || build.getId() > buildId;
            return bl;
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aggregateLatest(Build build, File workingDir, List<String> reportsets) {
        ReportCategory category = this.getCategory();
        DataReport aggregateReport = category.createReport(this.getAggregationOverviewReportName());
        DataRow destRow = aggregateReport.addRow();
        for (String each : reportsets) {
            DataReport sourceReport;
            File sourceDir = category.getReportDirOfBuild(build, each);
            if (!sourceDir.exists() || (sourceReport = category.loadReport(sourceDir, this.getStatsReportName(), new Filter[0])).isEmpty()) continue;
            DataRow sourceRow = sourceReport.getRow(0);
            this.aggregateOverview(sourceRow, destRow);
        }
        this.updateOverviewRow(build, reportsets, destRow);
        CategoryDb db = category.getCategoryDb(workingDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "ReportAggregator::aggregateLatest");
            db.update("DELETE FROM " + this.getAggregationOverviewReportName() + " WHERE configurationId = " + build.getConfiguration().getId());
            db.saveReport(aggregateReport, null);
        }
        finally {
            db.close();
        }
    }

    protected void updateOverviewRow(Build build, List<String> reportsets, DataRow destRow) {
        Date day = build.getEndDate();
        destRow.setValue("configurationId", (Object)build.getConfiguration().getId());
        destRow.setValue("day", (Object)day);
        destRow.setValue("buildId", (Object)build.getId());
        BuildFragment bf = new BuildFragment(build);
        destRow.setValue("buildfrag", (Object)bf);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        new DataRowMerger().process(sourceRow, destRow);
    }

    protected void updateStatsRow(DataRow row) {
    }

    protected Map<String, Object> getOverviewStats(Build build, File aggregationDir) {
        ReportCategory category = this.getCategory();
        return category.getDefaultStats(aggregationDir, this.getAggregationOverviewReportName(), Restrictions.le("day", build.getEndDate()));
    }

    protected void aggregateStats(Build build, File aggregationDir) {
        ReportCategory category = this.getCategory();
        Map<String, Object> stats = this.getOverviewStats(build, aggregationDir);
        DataReport report = category.createReport(this.getAggregationStatsReportName());
        DataRow row = report.addRow();
        row.fromMap(stats);
        row.setValue("day", (Object)DateUtils.truncate((Date)build.getEndDate(), (int)5));
        this.updateStatsRow(row);
        category.saveReport(aggregationDir, report, new AlwaysNewValue<DataRow>());
    }

    protected String[] getAggregateColumns() {
        ReportCategory category = this.getCategory();
        ReportMetaData meta = category.getMeta(this.getAggregationOverviewReportName());
        ArrayList list = Lists.newArrayList();
        for (DataColumn each : meta.getColumns()) {
            if (!each.isPrimary() && !each.getDataType().isIdType() && each.getDataType().isNumericType()) continue;
            list.add(each.getColumnName());
        }
        return (String[])Iterables.toArray((Iterable)list, String.class);
    }

    @Editable(name="Report sets", description="Specify the reportsets to be aggregated. Comma to separate each other, leave empty to aggregate all available reportsets.")
    public String getReportsets() {
        return this.reportsets;
    }

    public void setReportsets(String reportsets) {
        this.reportsets = reportsets;
    }
}

