/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.contribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildOverviewContribution;
import com.pmease.quickbuild.extensionpoint.BuildSummaryContribution;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.extensionpoint.PermissionContribution;
import com.pmease.quickbuild.extensionpoint.RestResourceContribution;
import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.extensionpoint.StatisticsTabContribution;
import com.pmease.quickbuild.extensionpoint.StepProvider;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.contribution.gadget.ReportGadgetProvider;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.StatisticsReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryBuildOverview;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryBuildTab;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryStatisticsTab;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.ReportSummaryContribution;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportPlugin
extends AbstractPlugin {
    protected ReportCategory category;
    private static final Logger logger = LoggerFactory.getLogger(AbstractReportPlugin.class);

    protected abstract Class<? extends Step> getPublishStepClass();

    protected abstract ReportCategory createCategory();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getReportCategory();
    }

    public Object[] getExtensions() {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (this.getPublishStepClass() != null) {
            objects.add(new StepProvider(){

                public Class<? extends Step> getStepClass() {
                    return AbstractReportPlugin.this.getPublishStepClass();
                }
            });
        }
        this.addExtension(objects, this.getPermissionContribution());
        this.addExtension(objects, this.getBuildMetricsCollector());
        this.addExtension(objects, this.getBuildTabContribution());
        this.addExtension(objects, this.getBuildSummaryContribution());
        this.addExtension(objects, this.getBuildDashboardContribution());
        this.addExtension(objects, this.getStatisticsTabContribution());
        this.addExtensions(objects, this.getAggregationSupport());
        this.addExtension(objects, this.getRestContribution());
        objects.addAll(this.getGadgetContributions());
        this.addExtensions(objects, this.getExtraExtensions());
        return Iterables.toArray(objects, Object.class);
    }

    protected final List<ReportGadgetProvider> getGadgetContributions() {
        ArrayList list = Lists.newArrayList();
        Class<? extends Gadget>[] gadgetClasses = this.getGadgetClasses();
        if (gadgetClasses != null && gadgetClasses.length > 0) {
            for (Class<? extends Gadget> each : gadgetClasses) {
                list.add(new ReportGadgetProvider(each));
            }
        }
        return list;
    }

    protected Object[] getAggregationSupport() {
        return null;
    }

    protected Object[] getExtraExtensions() {
        return null;
    }

    protected Class<? extends Gadget>[] getGadgetClasses() {
        return null;
    }

    protected void addExtension(List<Object> extensions, Object extension) {
        if (extension == null) {
            return;
        }
        extensions.add(extension);
    }

    protected void addExtensions(List<Object> extensions, Object[] objs) {
        if (objs != null && objs.length > 0) {
            for (Object each : objs) {
                this.addExtension(extensions, each);
            }
        }
    }

    protected PermissionContribution getPermissionContribution() {
        return new PermissionContribution(){

            public String[] getPermissions() {
                return new String[]{AbstractReportPlugin.this.getReportCategory().getName().toUpperCase()};
            }
        };
    }

    protected StatisticsSupport getBuildMetricsCollector() {
        return new StatisticsReportPublisher(){

            @Override
            protected ReportCategory getCategory() {
                return AbstractReportPlugin.this.getReportCategory();
            }

            @Override
            public boolean isApplicable(Build build) {
                if (!AbstractReportPlugin.this.hasBuildReport(build)) {
                    return false;
                }
                return super.isApplicable(build);
            }
        };
    }

    protected BuildTabContribution getBuildTabContribution() {
        return new CategoryBuildTab(){
            private static final long serialVersionUID = 1L;

            @Override
            protected ReportCategory getCategory() {
                return AbstractReportPlugin.this.getReportCategory();
            }

            @Override
            public boolean isApplicable() {
                if (!AbstractReportPlugin.this.hasBuildReport(Context.getBuild())) {
                    return false;
                }
                return super.isApplicable();
            }
        };
    }

    protected BuildOverviewContribution getBuildDashboardContribution() {
        return new CategoryBuildOverview(){

            @Override
            protected ReportCategory getCategory() {
                return AbstractReportPlugin.this.getReportCategory();
            }

            @Override
            public boolean isApplicable() {
                if (!AbstractReportPlugin.this.hasBuildReport(Context.getBuild())) {
                    return false;
                }
                return super.isApplicable();
            }
        };
    }

    protected BuildSummaryContribution getBuildSummaryContribution() {
        return new ReportSummaryContribution(){

            @Override
            public ReportCategory getCategory() {
                return AbstractReportPlugin.this.getReportCategory();
            }
        };
    }

    protected StatisticsTabContribution getStatisticsTabContribution() {
        return new CategoryStatisticsTab(){
            private static final long serialVersionUID = 1L;

            @Override
            public ReportCategory getCategory() {
                return AbstractReportPlugin.this.getReportCategory();
            }

            @Override
            public boolean isApplicable() {
                if (!AbstractReportPlugin.this.hasStatsReport(Context.getConfiguration())) {
                    return false;
                }
                return super.isApplicable();
            }
        };
    }

    protected Class<?>[] getRestResourceClasses() {
        return new Class[0];
    }

    protected final RestResourceContribution getRestContribution() {
        final Class[] classes = this.getRestResourceClasses();
        if (classes != null && classes.length > 0) {
            return new RestResourceContribution(){

                public Set<Class<?>> getResourceClasses() {
                    HashSet set = Sets.newHashSet((Object[])classes);
                    return set;
                }
            };
        }
        return null;
    }

    protected boolean hasBuildReport(Build build) {
        if (build == null) {
            return false;
        }
        ReportCategory category = this.getReportCategory();
        return category.getCategoryDirOfBuild(build).exists();
    }

    protected boolean hasStatsReport(Configuration configuration) {
        if (configuration == null) {
            return false;
        }
        ReportCategory category = this.getReportCategory();
        return category.getCategoryDirOfStats(configuration).exists();
    }

    protected boolean hasAggregationReport(Configuration configuration) {
        if (configuration == null) {
            return false;
        }
        ReportCategory category = this.getReportCategory();
        return category.getCategoryDirOfAggregation(configuration).exists();
    }

    public synchronized ReportCategory getReportCategory() {
        if (this.category == null || this.isDebug()) {
            logger.info("Constructing report category for plugin: " + (Object)((Object)this));
            this.category = this.createCategory();
        }
        Preconditions.checkNotNull((Object)this.category, (Object)("Cannot initialize the report category for plugin: " + (Object)((Object)this)));
        return this.category;
    }

    protected boolean isDebug() {
        return false;
    }

    public PluginCategory getCategory() {
        return PluginCategory.REPORTER;
    }
}

