/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.exception.MalFormedXMLException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.XMLSerializable;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportHelper {
    private static final Logger logger = LoggerFactory.getLogger(ReportHelper.class);
    private static final int MAX_LINES = 500;

    private ReportHelper() {
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static Locale getLocale(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return ReportHelper.getLocale();
        }
        try {
            return LocaleUtils.toLocale((String)str);
        }
        catch (IllegalArgumentException e) {
            return ReportHelper.getLocale();
        }
    }

    public static boolean isTestMode() {
        return Quickbuild.getInstance() == null;
    }

    public static Logger getLogger() {
        if (ReportHelper.isTestMode()) {
            return logger;
        }
        return Context.getLogger();
    }

    public static XMLSerializable fromXML(XMLSerializable obj, String xml) {
        try {
            if (StringUtils.isEmpty((String)xml)) {
                return obj;
            }
            Document doc = DocumentHelper.parseText((String)xml);
            Element element = doc.getRootElement();
            obj.fromXML(element);
            return obj;
        }
        catch (DocumentException e) {
            throw new MalFormedXMLException("The XML document is mal-formed.", e);
        }
    }

    public static Object evaluate(String expression, Map<String, Object> context) {
        if (StringUtils.isEmpty((String)expression)) {
            return null;
        }
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        return em.evaluate(expression, context);
    }

    public static String interpolate(String expression, Map<String, Object> context) {
        if (StringUtils.isEmpty((String)expression)) {
            return null;
        }
        ScriptEngine em = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        return em.interpolate(expression, context);
    }

    public static String evaluateVelocity(String template, Map<String, Object> bean) {
        VelocityContext context = new VelocityContext(bean);
        StringWriter writer = new StringWriter();
        StringReader reader = new StringReader(template);
        bean.putAll(VelocityUtils.TOOLS);
        bean.put("utils", ReportUtils.getInstance());
        boolean success = Velocity.evaluate((org.apache.velocity.context.Context)context, (Writer)writer, (String)"ReportHelper", (Reader)reader);
        if (success) {
            return writer.toString();
        }
        return null;
    }

    public static boolean isEquals(Object x, Object y) {
        return new EqualsBuilder().append(x, y).isEquals();
    }

    public static ReportCategory getCategory(Class<? extends AbstractReportPlugin> clazz) {
        AbstractReportPlugin plugin = (AbstractReportPlugin)PluginManager.instance.getPlugin(clazz);
        return plugin.getReportCategory();
    }

    @Nullable
    public static ReportCategory getCategory(String categoryId) {
        for (Plugin each : PluginManager.instance.getPlugins()) {
            AbstractReportPlugin p;
            ReportCategory category;
            if (!(each instanceof AbstractReportPlugin) || !Objects.equal((Object)(category = (p = (AbstractReportPlugin)each).getReportCategory()).getId(), (Object)categoryId)) continue;
            return category;
        }
        return null;
    }

    public static String streamToString(InputStream in, String encoding) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)in, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static String streamToString(InputStream in) {
        return ReportHelper.streamToString(in, "UTF-8");
    }

    public static String readClassResource(Class<?> clazz, String resource) {
        InputStream in = clazz.getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Unable to find resource " + resource + " for class " + clazz);
        }
        return ReportHelper.streamToString(in);
    }

    public static String renderSource(String source, String sourceType) {
        Renderer renderer = XhtmlRendererFactory.getRenderer((String)sourceType);
        if (renderer != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes("UTF-8"));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                renderer.highlight("", (InputStream)in, (OutputStream)out, "UTF-8", true);
                out.flush();
                return new String(out.toByteArray(), "UTF-8");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new StringBuffer().append("<pre>").append(source).append("</pre>").toString();
    }

    public static boolean ignoreCaseContains(Iterable<String> it, String want) {
        String str = (String)Iterables.find(it, (Predicate)new IgnorecaseEqual(want), null);
        return str != null;
    }

    public static boolean isShowReports(ReportCategory category) {
        String str = System.getProperty("showReports");
        if (!Strings.isNullOrEmpty((String)str)) {
            if (str.equalsIgnoreCase("no") || str.equalsIgnoreCase("false")) {
                return false;
            }
            if (str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("true")) {
                return true;
            }
            HashSet set = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)str), (Function)new Function<String, String>(){

                public String apply(String str) {
                    return str.toLowerCase();
                }
            }));
            return set.contains(category.getId());
        }
        return true;
    }

    public static void mergeText(DataRow destRow, DataRow sourceRow, String columnName) {
        String text = destRow.getValueAsString(columnName);
        String[] lines = StringUtils.split((String)text, (String)"\n");
        if (lines.length > 500) {
            return;
        }
        String source = sourceRow.getValueAsString(columnName);
        if (!StringUtils.isEmpty((String)source)) {
            text = !StringUtils.isEmpty((String)text) ? text + "___QB__LINE__SEP___" + source : source;
            destRow.setValue(columnName, (Object)text);
        }
    }

    static class IgnorecaseEqual
    implements Predicate<String> {
        private final String expected;

        public IgnorecaseEqual(String e) {
            this.expected = e;
        }

        public boolean apply(String input) {
            return this.expected.equalsIgnoreCase(input);
        }
    }
}

