/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.repo;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.plugin.scm.repo.GitCommand;
import com.pmease.quickbuild.plugin.scm.repo.RepoManifest;
import com.pmease.quickbuild.plugin.scm.repo.RepoProject;
import com.pmease.quickbuild.plugin.scm.repo.RepoRepository;
import com.pmease.quickbuild.plugin.scm.repo.RepoRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RepoSourceViewSupport
extends SourceViewSupport<RepoRevision> {
    private static final long serialVersionUID = 1L;

    public RepoSourceViewSupport(RepoRepository repository) {
        super((Repository)repository);
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            String checkoutFileCanonicalPath = checkoutFile.getCanonicalPath();
            String destDirCanonicalPath = this.getWorkingDir().getCanonicalPath();
            Context.getLogger().debug("Calculating repository path...");
            Context.getLogger().debug("Path to checkout file: " + checkoutFileCanonicalPath);
            Context.getLogger().debug("Path to repository destination directory: " + destDirCanonicalPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getWorkingDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        relativePath = StringUtils.stripStart((String)relativePath, (String)"/");
        return relativePath;
    }

    public List<String> readSourceByRevision(String repositoryPath, RepoRevision revision) {
        RepoProject project = this.getProjectOfPath(repositoryPath);
        GitCommand command = new GitCommand().revision(revision.getDate());
        LineListConsumer consumer = new LineListConsumer("UTF-8");
        command.execute(new File(this.getWorkingDir(), project.getPath()), (OutputStream)consumer, (LineConsumer)new LineConsumer.ErrorLogger("UTF-8"));
        String rev = consumer.firstLine();
        if (Strings.isNullOrEmpty((String)rev)) {
            throw new QuickbuildException("Unable to detect the repository revision for project " + project.getPath());
        }
        return this.show(repositoryPath, new GitRevision(rev));
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        return this.show(repositoryPath, new GitRevision(edition));
    }

    RepoProject getProjectOfPath(String repositoryPath) {
        File workingDir = this.getWorkingDir();
        if (!workingDir.exists()) {
            throw new QuickbuildException("Local repository directory does not exist.");
        }
        File dotRepo = new File(workingDir, ".repo");
        RepoManifest manifest = RepoManifest.readFrom(dotRepo);
        RepoProject current = null;
        for (RepoProject each : manifest.getProjects()) {
            if (!repositoryPath.startsWith(each.getPath())) continue;
            if (current == null) {
                current = each;
                continue;
            }
            if (current.getPath().length() >= each.getPath().length()) continue;
            current = each;
        }
        if (current == null) {
            throw new QuickbuildException("No project found for file " + repositoryPath);
        }
        return current;
    }

    public List<String> show(String path, GitRevision rev) {
        File workingDir = this.getWorkingDir();
        if (!workingDir.exists()) {
            throw new QuickbuildException("Local repository directory does not exist.");
        }
        RepoProject current = this.getProjectOfPath(path);
        LineListConsumer handler = new LineListConsumer(Log.LogLevel.DEBUG, "UTF-8");
        File dir = new File(workingDir, current.getPath());
        String fileName = FileUtils.getRelativePath((String)path, (String)current.getPath());
        fileName = StringUtils.stripStart((String)fileName, (String)"/");
        GitCommand command = new GitCommand().show(fileName, rev.toString());
        command.execute(dir, (OutputStream)handler, (LineConsumer)new LineConsumer.ErrorLogger("UTF-8"));
        return handler.getLines();
    }

    public RepoRepository getRepository() {
        return (RepoRepository)super.getRepository();
    }

    public File getWorkingDir() {
        return this.getRepository().getWorkingDir();
    }
}

