/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.repo;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.plugin.scm.git.GitUrl;
import com.pmease.quickbuild.plugin.scm.git.UserSchema;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.CommitterUtils;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LoggerConsumer;
import com.pmease.quickbuild.plugin.scm.repo.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.repo.GitCommand;
import com.pmease.quickbuild.plugin.scm.repo.RepoCli;
import com.pmease.quickbuild.plugin.scm.repo.RepoManifest;
import com.pmease.quickbuild.plugin.scm.repo.RepoPluginSetting;
import com.pmease.quickbuild.plugin.scm.repo.RepoProject;
import com.pmease.quickbuild.plugin.scm.repo.RepoRevision;
import com.pmease.quickbuild.plugin.scm.repo.RepoSourceViewSupport;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Google Repo", description="Configure a Google Repo repository here. You may need configure repo plugin and git plugin if the repo command and git command are not in system path.")
@ScriptApi
public class RepoRepository
extends AbstractRepository<RepoRevision> {
    private static final long serialVersionUID = 1L;
    private String manifestUrl = "git://android.git.kernel.org/platform/manifest.git";
    private String manifestFileName;
    private String manifestBranch;
    private String checkoutTag;
    private String username;
    private String password;
    private String destPath;
    private String userSchema = "Author Name";
    private int jobNumber = 5;
    public static final String MANIFEST_URL = "manifesturl";
    public static final String MANIFEST_BRANCH = "manifestbranch";
    static String DOT_REPO = ".repo";

    protected void checkoutByRevision(RepoRevision revision) {
        this.sync();
        final String tag = this.getCheckoutTag();
        if (!Strings.isNullOrEmpty((String)tag)) {
            List<Pair<String, String>> results = this.forall(new GitFunction<Pair<String, String>>(){

                public Pair<String, String> apply(RepoProject each) {
                    File dir = new File(RepoRepository.this.getWorkingDir(), each.getPath());
                    if (!dir.exists()) {
                        return new Pair((Object)each.getName(), (Object)("No project - " + each.getName() + " found on directory: " + dir));
                    }
                    RepoRepository.this.getLogger().info("Checking out project " + each.getName() + " to tag " + tag);
                    GitCommand cmd = new GitCommand().checkout(tag);
                    Commandline.ExecuteResult result = cmd.execute(dir, (OutputStream)LoggerConsumer.debugConsumer(), (LineConsumer)LoggerConsumer.errorConsumer());
                    if (result.getReturnCode() != 0) {
                        return new Pair((Object)each.getName(), (Object)result.getErrorMessage());
                    }
                    return null;
                }
            });
            for (Pair<String, String> each : results) {
                if (each == null) continue;
                System.out.println("Check out project " + (String)each.getFirst() + " failed due to: " + (String)each.getSecond());
            }
        }
    }

    protected RepoRevision getHeadRevision() {
        RepoRevision rev = new RepoRevision();
        rev.setDate(new Date());
        return rev;
    }

    protected void labelOnRevision(RepoRevision revision, String label, String comment) {
        RepoManifest manifest = RepoManifest.readFrom(this.dotRepo());
        String baseUrl = manifest.getDefaultFetchUrl();
        for (RepoProject each : manifest.getProjects()) {
            File dir = new File(this.getWorkingDir(), each.getPath());
            if (!dir.exists()) {
                this.getLogger().warn("The project " + each.getName() + " does not exist on directory: " + dir);
                continue;
            }
            Context.getLogger().debug("Get git revision of project " + each + " for build revision - " + (Object)((Object)revision));
            GitCommand cmd = new GitCommand().revision(revision.getDate());
            LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, "UTF-8");
            Commandline.ExecuteResult result = cmd.execute(dir, (OutputStream)consumer, (LineConsumer)LoggerConsumer.errorConsumer());
            result.checkReturnCode();
            String rev = consumer.firstLine();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)rev) ? 1 : 0) != 0, (Object)("Get revision of project " + each.getName() + " failed."));
            this.getLogger().debug("Add tag to local directory " + dir + " ...");
            String actualComment = comment;
            if (Strings.isNullOrEmpty((String)comment)) {
                actualComment = "Add tag " + label + " by QuickBuild";
            }
            cmd = new GitCommand().tagLocal(rev, label, actualComment);
            result = cmd.execute(dir, (OutputStream)LoggerConsumer.debugConsumer(), (LineConsumer)LoggerConsumer.infoConsumer());
            result.checkReturnCode();
            String pushUrl = StringUtils.stripEnd((String)baseUrl, (String)"/") + "/" + each.getName();
            this.getLogger().debug("Push tags to remote " + pushUrl + " ...");
            cmd = new GitCommand().tagRemote(this.getActualUrl(pushUrl, false), this.getActualUrl(pushUrl, true));
            result = cmd.execute(dir, (OutputStream)LoggerConsumer.debugConsumer(), (LineConsumer)LoggerConsumer.errorConsumer());
            result.checkReturnCode();
        }
    }

    public <T> List<T> forall(GitFunction<T> func) {
        RepoManifest manifest = RepoManifest.readFrom(this.dotRepo());
        return Lists.transform(manifest.getProjects(), func);
    }

    protected List<Changeset> getChangesBetween(final RepoRevision start, final RepoRevision end) {
        this.sync();
        ArrayList changes = Lists.newArrayList();
        List<List<Changeset>> arrays = this.forall(new GitFunction<List<Changeset>>(){

            public List<Changeset> apply(RepoProject each) {
                File dir = new File(RepoRepository.this.getWorkingDir(), each.getPath());
                if (!dir.exists()) {
                    RepoRepository.this.getLogger().warn("No changes found for project - " + each.getName() + " because the project does not check out.");
                    return Collections.emptyList();
                }
                GitCommand cmd = new GitCommand().log(start.getDate(), end.getDate());
                ChangeLogConsumer consumer = new ChangeLogConsumer(each.getName(), each.getPath(), RepoRepository.this.getSchemaValue());
                Commandline.ExecuteResult result = cmd.execute(dir, (OutputStream)((Object)consumer), (LineConsumer)new LineConsumer.ErrorLogger("UTF-8"));
                result.checkReturnCode();
                return consumer.getChanges();
            }
        });
        for (List<Changeset> each : arrays) {
            changes.addAll(each);
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sync() {
        RepoCli cli = new RepoCli(this);
        File workingDir = this.getWorkingDir();
        try {
            if (!workingDir.exists() || this.hasSettingChanged()) {
                if (workingDir.exists()) {
                    this.getLogger().info("Deleting old working directory ...");
                    FileUtils.deleteDir((File)this.getWorkingDir());
                }
                FileUtils.createDir((File)this.getWorkingDir());
                cli.repoinit();
            }
            cli.reposync(RepoCli.SyncType.BOTH);
        }
        finally {
            this.saveRC();
        }
    }

    protected boolean isQuietSince(Date date) {
        if (!this.exists()) {
            return false;
        }
        this.sync();
        RepoManifest manifest = RepoManifest.readFrom(this.dotRepo());
        for (RepoProject each : manifest.getProjects()) {
            File dir = new File(this.getWorkingDir(), each.getPath());
            if (!dir.exists()) {
                this.getLogger().warn("Ignore detecting changes for project - " + each.getName() + " because no project directory found - " + dir);
                continue;
            }
            GitCommand cmd = new GitCommand().log(date, null, 1);
            ChangeLogConsumer consumer = new ChangeLogConsumer(each.getName(), each.getPath(), this.getSchemaValue());
            cmd.execute(dir, (OutputStream)((Object)consumer), (LineConsumer)LoggerConsumer.errorConsumer());
            if (consumer.getChanges().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ProofBuildSupport<? extends LocalChange> getProofBuildSupport() {
        return null;
    }

    public SourceViewSupport<RepoRevision> getSourceViewSupport() {
        return new RepoSourceViewSupport(this);
    }

    @Editable(name="Manifest URL", order=1000, description="The location of the manifest repository (passed to repo init's -u option). Defaults to git://android.git.kernel.org/platform/manifest.git. ")
    @NotEmpty
    @ScriptApi(value="Get the url of manifest.git")
    @Scriptable
    public String getManifestUrl() {
        return this.manifestUrl;
    }

    public void setManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
    }

    @Editable(name="Manifest File Name", order=1200, description="The name of the initial manifest file (passed to repo init's -m option). Defaults to default.xml. ")
    @ScriptApi(value="Get the manifest file name.")
    @Scriptable
    public String getManifestFileName() {
        return this.manifestFileName;
    }

    public void setManifestFileName(String manifestFileName) {
        this.manifestFileName = manifestFileName;
    }

    @Editable(name="Manifest Branch", order=1100, description="The branch within the manifest repository to check out (passed to repo init's -b option). Defaults to master.")
    @ScriptApi(value="Get the manifest branch.")
    @Scriptable
    public String getManifestBranch() {
        return this.manifestBranch;
    }

    public void setManifestBranch(String manifestBranch) {
        this.manifestBranch = manifestBranch;
    }

    @Editable(name="Checkout Tag", order=1300, description="The tag which you want to checkout")
    @Scriptable
    @ScriptApi(value="Get the checkout tag.")
    public String getCheckoutTag() {
        return this.checkoutTag;
    }

    public void setCheckoutTag(String tag) {
        this.checkoutTag = tag;
    }

    @Editable(order=1400, name="User name", description="Optionally specify the user who has permission to access the above url.")
    @ScriptApi(value="Get the user name used to login the remote repository.")
    @Scriptable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    @Editable(order=1500, description="Specify password of the above user.<br><span class='bold red'>IMPORTANT:</span> For SSH based protocols (ssh, scp, sftp), please do NOT specify password here. You need to use public key authentication without pass phrase instead to avoid hanging. Refer to http://wiki.pmease.com for details.")
    @Password
    @ScriptApi(value="Get password to access the repository. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=1600, name="Destination Path", description="Specify the destination path to which contents in the above url will be retrieved into. This path is relative to the running configuration's workspace. If left empty, the workspace directory itself will be used to put checked out contents.")
    @ScriptApi(value="Get destination path to put checked out files. Null if workspace directory is used.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=1700, name="Committer User Schema", description="Consider author's or committer's name or email as the owner of each changeset.")
    @NotEmpty
    @ChoiceProvider(value="getAllSchema")
    public String getUserSchema() {
        return this.userSchema;
    }

    public void setUserSchema(String userSchema) {
        this.userSchema = userSchema;
    }

    @Editable(order=1800, name="Simultaneous Jobs", description="Number of projects to fetch simultaneously, passed to repo sync's -j option.")
    public int getJobNumber() {
        return this.jobNumber;
    }

    public void setJobNumber(int jobNumber) {
        this.jobNumber = jobNumber;
    }

    private static List<String> getAllSchema() {
        ArrayList<String> values = new ArrayList<String>();
        for (UserSchema each : UserSchema.values()) {
            values.add(each.getDisplayName());
        }
        return values;
    }

    private String getActualUrl(String url, boolean descriptive) {
        GitUrl scmUrl = new GitUrl(url, this.getUsername(), this.getPassword());
        if (descriptive) {
            return scmUrl.toDescriptiveString();
        }
        return scmUrl.toString();
    }

    public String getActualManifestUrl(boolean descriptive) {
        return this.getActualUrl(this.getManifestUrl(), descriptive);
    }

    public UserSchema getSchemaValue() {
        return UserSchema.fromDisplayName((String)this.getUserSchema());
    }

    public String getEmail(String committer) {
        switch (this.getSchemaValue()) {
            case AuthorEmail: 
            case CommitterEmail: {
                return committer;
            }
            case AuthorNameAndEmail: 
            case CommitterNameAndEmail: {
                return (String)CommitterUtils.splitUserAndEmail((String)committer).getSecond();
            }
        }
        return null;
    }

    public Properties getCurrentRC() {
        Properties properties = new Properties();
        properties.put(MANIFEST_URL, this.getActualManifestUrl(false));
        if (!Strings.isNullOrEmpty((String)this.getManifestBranch())) {
            properties.put(MANIFEST_BRANCH, this.getManifestBranch());
        } else {
            properties.put(MANIFEST_BRANCH, "master");
        }
        if (!Strings.isNullOrEmpty((String)this.getCheckoutTag())) {
            properties.put("CURRENT_TAG", this.getCheckoutTag());
        }
        return properties;
    }

    public String getRepoPath() {
        RepoPluginSetting setting = RepoPluginSetting.get();
        String path = setting.getRepoExePath();
        if (Strings.isNullOrEmpty((String)path)) {
            return "repo";
        }
        return path;
    }

    public File dotRepo() {
        return new File(this.getWorkingDir(), DOT_REPO);
    }

    public boolean exists() {
        return this.getWorkingDir().exists() && this.dotRepo().exists();
    }

    public String format(String type, Map<String, Object> map) {
        AbstractRepository.FormatType t = AbstractRepository.FormatType.valueOf((String)type);
        String rev = null;
        switch (t) {
            case CHANGEID: {
                rev = (String)map.get("changeId");
                break;
            }
            case EDITION: {
                rev = (String)map.get("edition");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format field type " + type);
            }
        }
        return new GitRevision(rev).toShortId();
    }

    private void migrate1(VersionedDocument vd, Stack<Integer> versions) {
        vd.setValue("jobNumber", "24");
    }

    static interface GitFunction<T>
    extends Function<RepoProject, T> {
    }
}

