/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.repo;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.scm.repo.RepoProject;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class RepoManifest {
    Map<String, Remote> remotes = Maps.newHashMap();
    List<RepoProject> projects = Lists.newArrayList();
    private String defaultRemote;
    private String defaultRevision;
    static final String FILE_NAME = "manifest.xml";

    public List<RepoProject> getProjects() {
        return this.projects;
    }

    public void setProjects(List<RepoProject> projects) {
        this.projects = projects;
    }

    private void open(File file) {
        if (!file.exists()) {
            return;
        }
        Document doc = XMLHelper.readXML((File)file);
        List nodes = doc.getRootElement().elements("remote");
        for (Element each : nodes) {
            Remote remote = new Remote();
            remote.setName(XMLHelper.getString((Node)each, (String)"./@name"));
            remote.setFetch(XMLHelper.getString((Node)each, (String)"./@fetch"));
            remote.setReview(XMLHelper.getString((Node)each, (String)"./@review"));
            this.remotes.put(remote.getName(), remote);
        }
        Element element = doc.getRootElement().element("default");
        if (element != null) {
            this.defaultRemote = XMLHelper.getString((Node)element, (String)"remote");
            this.defaultRevision = XMLHelper.getString((Node)element, (String)"revision");
        }
        nodes = doc.getRootElement().elements("project");
        for (Element each : nodes) {
            RepoProject project = new RepoProject();
            project.setName(XMLHelper.getString((Node)each, (String)"name"));
            project.setPath(XMLHelper.getString((Node)each, (String)"path"));
            project.setRemote(XMLHelper.getString((Node)each, (String)"remote"));
            project.setRevision(XMLHelper.getString((Node)each, (String)"revision"));
            if (Strings.isNullOrEmpty((String)project.getRemote())) {
                project.setRemote(this.defaultRemote);
            }
            this.projects.add(project);
        }
    }

    public static RepoManifest readFrom(File dotRepo) {
        File manifestFile = new File(dotRepo, FILE_NAME);
        if (!manifestFile.exists()) {
            throw new QuickbuildException("Manifest file " + manifestFile + " does not exist!");
        }
        RepoManifest manifest = new RepoManifest();
        manifest.open(manifestFile);
        return manifest;
    }

    public String getDefaultRemote() {
        return this.defaultRemote;
    }

    public void setDefaultRemote(String defaultRemote) {
        this.defaultRemote = defaultRemote;
    }

    public String getDefaultRevision() {
        return this.defaultRevision;
    }

    public void setDefaultRevision(String defaultRevision) {
        this.defaultRevision = defaultRevision;
    }

    public Map<String, Remote> getRemotes() {
        return this.remotes;
    }

    public void setRemotes(Collection<Remote> remotes) {
        for (Remote each : remotes) {
            this.remotes.put(each.getName(), each);
        }
    }

    public String getDefaultFetchUrl() {
        Remote remote = this.remotes.get(this.getDefaultRemote());
        Preconditions.checkNotNull((Object)remote, (Object)("No default remote defined! Expected: " + this.getDefaultRemote()));
        return remote.getFetch();
    }

    public class Remote {
        private String name;
        private String fetch;
        private String review;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFetch() {
            return this.fetch;
        }

        public void setFetch(String fetch) {
            this.fetch = fetch;
        }

        public String getReview() {
            return this.review;
        }

        public void setReview(String review) {
            this.review = review;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("Name", (Object)this.name).add("Fetch", (Object)this.fetch).add("Review", (Object)this.review).toString();
        }
    }
}

