/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.repo;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCli;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LoggerConsumer;
import com.pmease.quickbuild.plugin.scm.repo.RepoCommand;
import com.pmease.quickbuild.plugin.scm.repo.RepoRepository;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepoCli
extends ScmCli<RepoCli, RepoRepository, RepoCommand> {
    static Pattern pPercent = Pattern.compile("Checking out files: d+% (d+/d+)");

    public RepoCli(RepoRepository repository) {
        super((AbstractRepository)repository, "UTF-8");
    }

    protected RepoCommand createCommand() {
        return new RepoCommand((RepoRepository)this.repository);
    }

    protected void doSync() {
        if (((RepoRepository)this.repository).exists()) {
            this.reposync(SyncType.BOTH);
        } else {
            FileUtils.createDir((File)this.getWorkingDir());
            this.repoinit();
            this.reposync(SyncType.BOTH);
        }
    }

    public RepoCli reposync(SyncType syncType) {
        Context.getLogger().info("Syncing repo repository ...");
        RepoCommand cmd = new RepoCommand((RepoRepository)this.getRepository());
        int jobNumber = ((RepoRepository)this.repository).getJobNumber();
        if (jobNumber <= 0) {
            jobNumber = 5;
        }
        cmd.addArgLine("sync").addArgLine("-f -j" + jobNumber);
        switch (syncType) {
            case LOCAL_ONLY: {
                cmd.addArgLine("-l");
                break;
            }
            case NETWORK_ONLY: {
                cmd.addArgLine("-n");
                break;
            }
            case BOTH: {
                break;
            }
        }
        cmd.quiet();
        return (RepoCli)this.run(cmd, (LineConsumer)LoggerConsumer.infoConsumer(), (LineConsumer)new LoggerConsumer(Log.LogLevel.INFO, "UTF-8"){

            public void consume(String line) {
                if (Strings.isNullOrEmpty((String)line)) {
                    return;
                }
                Matcher m = pPercent.matcher(line);
                if (m.find()) {
                    return;
                }
                super.consume(line);
            }
        });
    }

    public RepoCli repoinit() {
        Context.getLogger().info("Initializing repo repository ...");
        RepoCommand cmd = this.createCommand();
        cmd.addParameter("init -u", ((RepoRepository)this.repository).getActualManifestUrl(false), ((RepoRepository)this.repository).getActualManifestUrl(true));
        String branch = ((RepoRepository)this.repository).getManifestBranch();
        if (Strings.isNullOrEmpty((String)branch)) {
            branch = "master";
        }
        cmd.addParameter("-b", branch);
        String fileName = ((RepoRepository)this.repository).getManifestFileName();
        if (!Strings.isNullOrEmpty((String)fileName)) {
            cmd.addParameter("-m", fileName);
        }
        cmd.quiet();
        return (RepoCli)this.run(cmd, (LineConsumer)LoggerConsumer.infoConsumer(), (LineConsumer)LoggerConsumer.infoConsumer());
    }

    public static enum SyncType {
        LOCAL_ONLY,
        NETWORK_ONLY,
        BOTH;

    }
}

