/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.repo;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.plugin.scm.git.GitPluginSetting;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class GitCommand
extends Commandline {
    public static String DATE_FMT = "yyyy-MM-dd HH:mm:ss";

    public GitCommand() {
        this.setExecutable(GitCommand.getGitPath());
    }

    static String getGitPath() {
        GitPluginSetting setting = GitPluginSetting.get();
        String path = setting.getGitExePath();
        if (StringUtils.isEmpty((String)path)) {
            return "git";
        }
        return path;
    }

    GitCommand quiet() {
        if (!Context.getLogger().isDebugEnabled()) {
            this.addArgLine("--quiet");
        }
        return this;
    }

    GitCommand branch(String branch) {
        if (!Strings.isNullOrEmpty((String)branch)) {
            this.addArgLine("-b").addArgValue(branch);
        }
        return this;
    }

    GitCommand urlFor(final String url, final String descriptiveUrl) {
        this.addArgValue(url);
        if (!StringUtils.isEmpty((String)descriptiveUrl)) {
            this.setSecretMasker(new SecretMasker(){

                public String mask(String message) {
                    return StringUtils.replace((String)message, (String)url, (String)descriptiveUrl);
                }
            });
        }
        return this;
    }

    GitCommand subcommand(String subcmd) {
        this.addArgLine(subcmd);
        this.quiet();
        return this;
    }

    public GitCommand clone(String fetchUrl, String descriptiveUrl, String destPath, String branch, boolean subModule) {
        this.subcommand("clone");
        if (subModule) {
            this.addArgLine("--recursive");
        }
        this.branch(branch);
        this.urlFor(fetchUrl, descriptiveUrl);
        this.addArgValue(destPath);
        return this;
    }

    public GitCommand fetch() {
        return this.subcommand("fetch");
    }

    public GitCommand fetch(String refspec) {
        this.fetch().addArgValue(refspec);
        return this;
    }

    public GitCommand clean() {
        this.addArgLine("clean -fdx");
        this.quiet();
        return this;
    }

    public GitCommand merge(String revspec) {
        this.subcommand("merge").addArgValue(revspec);
        return this;
    }

    public GitCommand push(String pushUrl, String descriptiveUrl, String refspec) {
        this.subcommand("push");
        this.urlFor(pushUrl, descriptiveUrl);
        if (!StringUtils.isEmpty((String)refspec)) {
            this.addArgValue(refspec);
        }
        return this;
    }

    public GitCommand checkout(String refspec) {
        this.subcommand("checkout").addArgLine("-f").addArgValue(refspec);
        return this;
    }

    public GitCommand updateSubModules() {
        this.addArgLine("submodule update --init --recursive");
        return this;
    }

    public GitCommand config(String options, String property, String value) {
        this.subcommand("config");
        if (!Strings.isNullOrEmpty((String)options)) {
            this.addArgLine(options);
        }
        this.addArgLine(property).addArgValue(value);
        return this;
    }

    public GitCommand tagLocal(String revspec, String tagName, String comment) {
        this.addArgLine("tag -a -f -m");
        String actualComment = StringUtils.isEmpty((String)comment) ? "Tag for revision " + revspec : comment;
        this.addArgValue(actualComment);
        this.addArgValue(tagName);
        this.addArgValue(revspec);
        return this;
    }

    public GitCommand tagRemote(String pushUrl, String descriptiveUrl) {
        this.subcommand("push").addArgLine("--tags");
        this.urlFor(pushUrl, descriptiveUrl);
        return this;
    }

    public GitCommand branchLocal(String branchName, String revspec) {
        this.subcommand("checkout").addArgLine("--track -b").addArgValue(branchName).addArgValue(revspec);
        return this;
    }

    public GitCommand revision(Date date) {
        this.addArgLine("log -1 --pretty=%H");
        return this.until(date);
    }

    public GitCommand revision(String revspec) {
        this.addArgLine("log -1 --pretty=%H").addArgValue(revspec);
        return this;
    }

    private GitCommand log(String revspec, int size) {
        this.addArgLine("log --name-status --pretty=raw");
        if (!Strings.isNullOrEmpty((String)revspec)) {
            this.addArgValue(revspec);
        }
        if (size > 0) {
            this.addArgLine("-" + size);
        }
        return this;
    }

    GitCommand since(Date since) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FMT);
        if (since != null) {
            this.addArgLine("--since=\"" + fmt.format(since) + "\"");
        }
        return this;
    }

    GitCommand until(Date until) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FMT);
        if (until != null) {
            this.addArgLine("--until=\"" + fmt.format(until) + "\"");
        }
        return this;
    }

    public GitCommand log(Date since, Date until) {
        return this.log(since, until, 0);
    }

    public GitCommand log(Date since, Date until, int size) {
        return this.log(null, size).since(since).until(until);
    }

    public GitCommand show(String path, String revspec) {
        this.addArgLine("show").addArgValue(revspec + ":" + path);
        return this;
    }
}

