/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover.line;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.report.clover.line.CloverLine;
import com.pmease.quickbuild.plugin.report.engine.datatype.BlockType;
import com.pmease.quickbuild.plugin.report.engine.exception.TypeCastException;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.web.page.source.Block;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.wicket.util.io.IOUtils;

public class CloverLineType
extends BlockType {
    private static final long serialVersionUID = 1L;

    public CloverLine getDefaultValue() {
        return new CloverLine();
    }

    protected String getWriteFormat() {
        return "XML";
    }

    public Object fromString(String str, String pattern, Locale locale) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.fromXML(str);
        }
        try {
            String[] tokens = new CSVParser(':').parse(str);
            CloverLine line = this.getDefaultValue();
            int i = 0;
            line.setStartLine(Integer.valueOf(tokens[i++]));
            line.setEndLine(Integer.valueOf(tokens[i++]));
            line.setCount(Integer.valueOf(tokens[i++]));
            line.setFalseCount(Integer.valueOf(tokens[i++]));
            line.setTrueCount(Integer.valueOf(tokens[i++]));
            line.setComplexity(Integer.valueOf(tokens[i++]));
            line.setLineType(CloverLine.LineType.valueOf(tokens[i++]));
            return line;
        }
        catch (Exception e) {
            throw new TypeCastException((Object)str, (DataType)this);
        }
    }

    public String asString(Object value, String pattern, Locale locale) {
        Block block = this.typeCast(value);
        if (block == null) {
            return null;
        }
        if ("XML".equalsIgnoreCase(pattern)) {
            return VersionedDocument.xstream.toXML((Object)block);
        }
        CloverLine line = (CloverLine)block;
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)sw, ':');
        ArrayList tokens = Lists.newArrayList();
        tokens.add(String.valueOf(line.getStartLine()));
        tokens.add(String.valueOf(line.getEndLine()));
        tokens.add(String.valueOf(line.getCount()));
        tokens.add(String.valueOf(line.getFalseCount()));
        tokens.add(String.valueOf(line.getTrueCount()));
        tokens.add(String.valueOf(line.getComplexity()));
        tokens.add(line.getLineType().name());
        try {
            writer.join((Collection)tokens);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)sw);
        }
    }
}

