/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover.line;

import com.pmease.quickbuild.plugin.report.clover.line.CloverLine;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.ViewSourceLinkItem;
import com.pmease.quickbuild.web.page.source.Block;
import com.pmease.quickbuild.web.page.source.SourceViewPage;

public class CloverLineItem
extends ViewSourceLinkItem {
    private static final long serialVersionUID = 1L;

    public CloverLineItem(AbstractRenderer renderer) {
        super(renderer);
    }

    protected SourceViewPage createSourceViewPage(String title, String sourceType, String[] lines, Block[] blocks, int startLine) {
        return new SourceViewPage(title, sourceType, lines, blocks, startLine){
            private static final long serialVersionUID = 1L;

            protected String renderContent(String[] lines, Block[] blocks) {
                StringBuffer sb = new StringBuffer();
                int i = 1;
                sb.append("<table>");
                if (blocks.length > 0) {
                    for (Block each : blocks) {
                        while (i < each.getStartLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits'></td>");
                            sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                        CloverLine line = (CloverLine)each;
                        String color = CloverLineItem.getBlockColor(line);
                        String message = line.toString();
                        while (i <= each.getEndLine()) {
                            sb.append("<tr>");
                            sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                            sb.append("<td class='hits' style='background-color: ").append(color).append("'>").append("<div class='with-msg' ").append("title='").append(message).append("'>").append(line.getExecuteCount()).append("</div>").append("</td>");
                            sb.append("<td class='line-content' style='border-color: ").append(color).append("'>").append(lines[i - 1]).append("</td>");
                            sb.append("</tr>");
                            ++i;
                        }
                    }
                }
                while (i <= lines.length) {
                    sb.append("<tr>");
                    sb.append("<td class='line-no'><a name='").append(i).append("'>").append(i).append("</td>");
                    if (blocks.length > 0) {
                        sb.append("<td class='hits'></td>");
                    }
                    sb.append("<td class='line-content'>").append(lines[i - 1]).append("</td>");
                    sb.append("</tr>");
                    ++i;
                }
                sb.append("</table>");
                return sb.toString();
            }
        };
    }

    static String getBlockColor(CloverLine line) {
        if (line.getExecuteCount() == 0) {
            return "#FF1A00";
        }
        if (line.getLineType() == CloverLine.LineType.CONDITIONAL && (line.getTrueCount() == 0 || line.getFalseCount() == 0)) {
            return "#FF1A00";
        }
        return "#008C00";
    }
}

