/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover.line;

import com.pmease.quickbuild.web.page.source.Block;

public class CloverLine
extends Block {
    private static final long serialVersionUID = 1L;
    private int count;
    private int falseCount;
    private int trueCount;
    private int complexity;
    private LineType lineType;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getFalseCount() {
        return this.falseCount;
    }

    public void setFalseCount(int falseCount) {
        this.falseCount = falseCount;
    }

    public int getTrueCount() {
        return this.trueCount;
    }

    public void setTrueCount(int trueCount) {
        this.trueCount = trueCount;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public void setLineType(LineType lineType) {
        this.lineType = lineType;
    }

    public int getExecuteCount() {
        if (this.lineType == LineType.CONDITIONAL) {
            return this.trueCount + this.falseCount;
        }
        return this.count;
    }

    public String toString() {
        int executeCount;
        StringBuffer sb = new StringBuffer();
        sb.append(this.lineType == LineType.CONDITIONAL ? "branch" : this.lineType.name().toLowerCase()).append(", ");
        if (this.lineType == LineType.METHOD) {
            sb.append("complexity: ").append(this.complexity).append(", ");
        }
        if ((executeCount = this.getExecuteCount()) == 0) {
            sb.append("not executed.");
        } else {
            sb.append("executed ").append(this.getExecuteCount()).append(" times");
            if (this.lineType == LineType.CONDITIONAL) {
                sb.append(", true branch executed ").append(this.trueCount).append(" times");
            }
            sb.append(".");
        }
        return sb.toString();
    }

    public static enum LineType {
        METHOD,
        STATEMENT,
        CONDITIONAL;


        public static LineType of(String val) {
            if (val.equalsIgnoreCase("method")) {
                return METHOD;
            }
            if (val.equalsIgnoreCase("stmt")) {
                return STATEMENT;
            }
            if (val.equalsIgnoreCase("cond")) {
                return CONDITIONAL;
            }
            throw new IllegalArgumentException("Unknown type " + val);
        }
    }
}

