/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.plugin.report.clover.generator.AbstractCoverageProcessor;
import com.pmease.quickbuild.plugin.report.clover.line.CloverLine;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class FilesProcessor
extends AbstractCoverageProcessor {
    private static final long serialVersionUID = 1L;

    public FilesProcessor(ReportCategory category) {
        super(category);
    }

    @Override
    protected String[] getMetricNames() {
        return new String[]{"classes", "loc", "ncloc", "complexity", "elements", "coveredElements", "conditionals", "coveredConditionals", "methods", "coveredMethods", "statements", "coveredStatements"};
    }

    @Override
    protected void processElement(Element element, DataRow row) {
        super.processElement(element, row);
        String path = element.valueOf("../@path");
        String workspacePath = GeneratorContext.getContext().getWorkspaceDir();
        path = ReportUtils.getRelativePath((String)path, (String)workspacePath);
        row.setValue("path", (Object)path);
        Element parent = element.getParent();
        List nodes = parent.elements("line");
        HashMap lines = Maps.newHashMap();
        for (Element each : nodes) {
            int num = Integer.valueOf(each.attributeValue("num"));
            CloverLine line = (CloverLine)((Object)lines.get(num));
            if (line == null) {
                line = new CloverLine();
                line.setStartLine(num);
                line.setEndLine(num);
                lines.put(num, line);
            }
            CloverLine.LineType type = CloverLine.LineType.of(each.attributeValue("type"));
            line.setLineType(type);
            if (type == CloverLine.LineType.CONDITIONAL) {
                line.setTrueCount(XMLHelper.getInt((Node)each, (String)"./@truecount", (Integer)0));
                line.setFalseCount(XMLHelper.getInt((Node)each, (String)"./@falsecount", (Integer)0));
            } else {
                line.setCount(XMLHelper.getInt((Node)each, (String)"./@count", (Integer)0));
            }
            if (type != CloverLine.LineType.METHOD) continue;
            line.setComplexity(XMLHelper.getInt((Node)each, (String)"./@complexity", (Integer)0));
        }
        ArrayList linesOfFile = Lists.newArrayList(lines.values());
        Collections.sort(linesOfFile);
        row.setValue("lines", (Object)linesOfFile);
    }

    @Override
    public String getRootXPath() {
        return "package/file";
    }
}

