/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.ResourceReader;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorResource;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class AbstractCoverageProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public AbstractCoverageProcessor(ReportCategory category) {
        super(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResource(GeneratorResource resource) {
        ResourceReader reader = this.createReader();
        if (reader == null) {
            return;
        }
        GeneratorContext context = this.getContext();
        context.setResource((Object)resource);
        try {
            DataRow row;
            Document doc;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Start opening original document");
            }
            if ((doc = (Document)reader.read()) == null) {
                return;
            }
            DataReport report = context.getDestReport();
            List nodes = doc.selectNodes("/coverage/project/" + this.getRootXPath() + "/metrics");
            for (Element each : nodes) {
                row = report.addRow();
                row.setValue("isTestProject", (Object)false);
                this.processElement(each, row);
            }
            nodes = doc.selectNodes("/coverage/testproject/" + this.getRootXPath() + "/metrics");
            for (Element each : nodes) {
                row = report.addRow();
                row.setValue("isTestProject", (Object)true);
                this.processElement(each, row);
            }
        }
        finally {
            reader.close();
        }
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void processElement(Element element, DataRow row) {
        for (String name : this.getMetricNames()) {
            row.setValue(name, (Object)XMLHelper.getInt((Node)element, (String)("./@" + name.toLowerCase()), (Integer)0));
        }
        row.setValue("conditionalCoverage", (Object)ReportUtils.divide((int)row.getInt("coveredConditionals"), (int)row.getInt("conditionals")));
        row.setValue("methodCoverage", (Object)ReportUtils.divide((int)row.getInt("coveredMethods"), (int)row.getInt("methods")));
        row.setValue("elementCoverage", (Object)ReportUtils.divide((int)row.getInt("coveredElements"), (int)row.getInt("elements")));
        row.setValue("statementCoverage", (Object)ReportUtils.divide((int)row.getInt("coveredStatements"), (int)row.getInt("statements")));
    }

    protected abstract String[] getMetricNames();

    public abstract String getRootXPath();
}

