/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.plugin.report.clover.CloverPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;

@Editable(name="Clover Report")
public class CloverAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(CloverPlugin.class);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        this.updateCoverages(destRow);
    }

    protected void updateStatsRow(DataRow row) {
        this.updateCoverages(row);
    }

    private void updateCoverages(DataRow row) {
        row.setValue("elementCoverage", (Object)this.getCoverage(row, "coveredElements", "elements"));
        row.setValue("methodCoverage", (Object)this.getCoverage(row, "coveredMethods", "methods"));
        row.setValue("statementCoverage", (Object)this.getCoverage(row, "coveredStatements", "statements"));
        row.setValue("conditionalCoverage", (Object)this.getCoverage(row, "coveredConditionals", "conditionals"));
    }

    private double getCoverage(DataRow row, String covered, String total) {
        return ReportUtils.divide((int)row.getInt(covered), (int)row.getInt(total));
    }
}

