/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.clover;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.report.clover.CloverPlugin;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.BuildReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

@Editable(category={"Publish"}, name="Clover Report", description="Publish Clover reports")
@ScriptApi(value="This step publishes the original Clover XML files.")
public class CloverPublisher
extends BuildReportPublisher {
    private static final long serialVersionUID = 1L;
    @XStreamOmitField
    private int packages;
    @XStreamOmitField
    private int classes;
    @XStreamOmitField
    private int files;
    @XStreamOmitField
    private int conditionals;
    @XStreamOmitField
    private int coveredConditionals;
    @XStreamOmitField
    private double conditionalCoverage;
    @XStreamOmitField
    private int methods;
    @XStreamOmitField
    private int coveredMethods;
    @XStreamOmitField
    private double methodCoverage;
    @XStreamOmitField
    private int statements;
    @XStreamOmitField
    private int coveredStatements;
    @XStreamOmitField
    private double statementCoverage;
    @XStreamOmitField
    private int elements;
    @XStreamOmitField
    private int coveredElements;
    @XStreamOmitField
    private double elementCoverage;
    @XStreamOmitField
    private int loc;
    @XStreamOmitField
    private int ncloc;
    @XStreamOmitField
    private int complexity;

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(CloverPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveStatsReport() {
        GeneratorContext context = GeneratorContext.getContext();
        File dbDir = context.getWorkingDir();
        ReportCategory category = this.getCategory();
        DataReport statsReport = category.createReport("stats");
        if (!dbDir.exists()) {
            return;
        }
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "CloverPublisher::saveStatsReport");
            Map map = category.getDefaultStats(db, "packages", new Filter[]{Restrictions.eq((String)"isTestProject", (Object)false)});
            DataRow row = statsReport.addRow();
            this.packages = MapUtils.getIntValue((Map)map, (Object)"totals");
            this.classes = MapUtils.getIntValue((Map)map, (Object)"classes");
            this.files = MapUtils.getIntValue((Map)map, (Object)"files");
            this.loc = MapUtils.getIntValue((Map)map, (Object)"loc");
            this.ncloc = MapUtils.getIntValue((Map)map, (Object)"ncloc");
            this.complexity = MapUtils.getIntValue((Map)map, (Object)"complexity");
            this.statements = MapUtils.getIntValue((Map)map, (Object)"statements");
            this.coveredStatements = MapUtils.getIntValue((Map)map, (Object)"coveredStatements");
            this.statementCoverage = ReportUtils.divide((int)this.coveredStatements, (int)this.statements);
            this.methods = MapUtils.getIntValue((Map)map, (Object)"methods");
            this.coveredMethods = MapUtils.getIntValue((Map)map, (Object)"coveredMethods");
            this.methodCoverage = ReportUtils.divide((int)this.coveredMethods, (int)this.methods);
            this.conditionals = MapUtils.getIntValue((Map)map, (Object)"conditionals");
            this.coveredConditionals = MapUtils.getIntValue((Map)map, (Object)"coveredConditionals");
            this.conditionalCoverage = ReportUtils.divide((int)this.coveredConditionals, (int)this.conditionals);
            this.elements = MapUtils.getIntValue((Map)map, (Object)"elements");
            this.coveredElements = MapUtils.getIntValue((Map)map, (Object)"coveredElements");
            this.elementCoverage = ReportUtils.divide((int)this.coveredElements, (int)this.elements);
            row.fromMap(map);
            row.setValue("buildId", (Object)Context.getBuild().getId());
            row.setValue("statementCoverage", (Object)this.statementCoverage);
            row.setValue("methodCoverage", (Object)this.methodCoverage);
            row.setValue("conditionalCoverage", (Object)this.conditionalCoverage);
            row.setValue("elementCoverage", (Object)this.elementCoverage);
            category.saveReport(db, statsReport);
        }
        finally {
            db.close();
        }
    }

    protected String getStatsReportName() {
        return "stats";
    }

    @ScriptApi
    public int getPackages() {
        return this.packages;
    }

    public void setPackages(int packages) {
        this.packages = packages;
    }

    @ScriptApi
    public int getClasses() {
        return this.classes;
    }

    public void setClasses(int classes) {
        this.classes = classes;
    }

    @ScriptApi
    public int getFiles() {
        return this.files;
    }

    public void setFiles(int files) {
        this.files = files;
    }

    @ScriptApi
    public int getConditionals() {
        return this.conditionals;
    }

    public void setConditionals(int conditionals) {
        this.conditionals = conditionals;
    }

    @ScriptApi
    public int getCoveredConditionals() {
        return this.coveredConditionals;
    }

    public void setCoveredConditionals(int coveredConditionals) {
        this.coveredConditionals = coveredConditionals;
    }

    @ScriptApi
    public double getConditionalCoverage() {
        return this.conditionalCoverage;
    }

    public void setConditionalCoverage(double conditionalCoverage) {
        this.conditionalCoverage = conditionalCoverage;
    }

    @ScriptApi
    public int getMethods() {
        return this.methods;
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    @ScriptApi
    public int getCoveredMethods() {
        return this.coveredMethods;
    }

    public void setCoveredMethods(int coveredMethods) {
        this.coveredMethods = coveredMethods;
    }

    @ScriptApi
    public double getMethodCoverage() {
        return this.methodCoverage;
    }

    public void setMethodCoverage(double methodCoverage) {
        this.methodCoverage = methodCoverage;
    }

    @ScriptApi
    public int getStatements() {
        return this.statements;
    }

    public void setStatements(int statements) {
        this.statements = statements;
    }

    @ScriptApi
    public int getCoveredStatements() {
        return this.coveredStatements;
    }

    public void setCoveredStatements(int coveredStatements) {
        this.coveredStatements = coveredStatements;
    }

    @ScriptApi
    public double getStatementCoverage() {
        return this.statementCoverage;
    }

    public void setStatementCoverage(double statementCoverage) {
        this.statementCoverage = statementCoverage;
    }

    @ScriptApi
    public int getElements() {
        return this.elements;
    }

    public void setElements(int elements) {
        this.elements = elements;
    }

    @ScriptApi
    public int getCoveredElements() {
        return this.coveredElements;
    }

    public void setCoveredElements(int coveredElements) {
        this.coveredElements = coveredElements;
    }

    @ScriptApi
    public double getElementCoverage() {
        return this.elementCoverage;
    }

    public void setElementCoverage(double elementCoverage) {
        this.elementCoverage = elementCoverage;
    }

    @ScriptApi
    public int getLoc() {
        return this.loc;
    }

    public void setLoc(int loc) {
        this.loc = loc;
    }

    @ScriptApi
    public int getNcloc() {
        return this.ncloc;
    }

    public void setNcloc(int ncloc) {
        this.ncloc = ncloc;
    }

    @ScriptApi
    public int getComplexity() {
        return this.complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
    }
}

