/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.xunit.renderer;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.xunit.renderer.TestDetailsColumn;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TestDetailsColumnPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final TestDetailsColumn column;

    public TestDetailsColumnPanel(String id, IModel<ItemContext> model, TestDetailsColumn column) {
        super(id, model);
        this.column = column;
    }

    protected void onInitialize() {
        super.onInitialize();
        DataRow row = this.getRow();
        this.add(new Component[]{new Label("testName", row.getValueAsString("testName"))});
        String status = row.getValueAsString("status");
        status = ReportUtils.firstOf((String)status, (int)4);
        Label label = new Label("status", status);
        label.add(new Behavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)status.toLowerCase())), " ")});
        this.add(new Component[]{label});
        this.add(new Component[]{new Label("diffStatus", row.getValueAsString("diffStatus"))});
        int runs = (Integer)row.getValue("totalRuns");
        WebMarkupContainer runsContainer = new WebMarkupContainer("runsContainer");
        this.add(new Component[]{runsContainer});
        if (runs > 1) {
            runsContainer.add(new Component[]{new Label("totalRuns", String.valueOf(runs))});
            runsContainer.add(new Component[]{new Label("passedRuns", row.getValueAsString("passedRuns"))});
            runsContainer.add(new Component[]{new Label("failedRuns", row.getValueAsString("failedRuns"))});
        } else {
            runsContainer.setVisible(false);
        }
        FilterLinkItem suiteItem = this.column.getSuiteFilterLink();
        this.add(new Component[]{suiteItem.createComponent("suiteName", this.getDefaultModel())});
        this.add(new Component[]{new WebMarkupContainer("toTop").setVisible(!this.column.getRenderer().isInDropDown())});
        this.add(new Component[]{this.createLabel(row, "errorTypes")});
        this.add(new Component[]{this.createLabel(row, "errorMessages")});
        this.add(new Component[]{this.createLabel(row, "messages")});
    }

    private DataRow getRow() {
        ItemContext context = (ItemContext)this.getDefaultModelObject();
        return context.getDataRow();
    }

    private Component createLabel(DataRow row, String id) {
        List list = (List)row.getValue(id);
        return new Label(id, this.formatMessage(list)).setEscapeModelStrings(false).setVisible(!list.isEmpty());
    }

    private String formatMessage(List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("<ol>");
            for (int i = 0; i < list.size() && i <= 5; ++i) {
                sb.append("<li><pre>").append(StringEscapeUtils.escapeHtml((String)list.get(i))).append("</pre></li>");
            }
            sb.append("</ol>");
            if (list.size() > 5) {
                sb.append("<p>...</p>");
            }
            return sb.toString();
        }
        return "<pre>" + list.get(0) + "</pre>";
    }
}

