/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.xunit.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.xunit.generator.TestStatus;
import java.util.List;

public class TestDuplicateRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;

    public TestDuplicateRule(ReportCategory category) {
        super(category);
    }

    protected void mergeList(DataRow source, DataRow dest, String property) {
        List s = (List)source.getValue(property);
        List d = (List)dest.getValue(property);
        d.addAll(s);
        dest.setValue(property, (Object)d);
    }

    public void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow destRow = context.getDestRow();
        DataRow sourceRow = context.getSourceRow();
        this.mergeList(sourceRow, destRow, "errorTypes");
        this.mergeList(sourceRow, destRow, "errorMessages");
        this.mergeList(sourceRow, destRow, "messages");
        TestStatus destStatus = TestStatus.valueOf(destRow.getValueAsString("status").toUpperCase());
        TestStatus sourceStatus = TestStatus.valueOf(sourceRow.getValueAsString("status").toUpperCase());
        switch (sourceStatus) {
            case FAIL: {
                destStatus = sourceStatus;
                break;
            }
            case PASS: {
                if (destStatus != TestStatus.SKIP) break;
                destStatus = sourceStatus;
                break;
            }
        }
        destRow.setValue("status", (Object)destStatus.name());
        int totalRuns = destRow.getInt("totalRuns") + 1;
        destRow.setValue("totalRuns", (Object)totalRuns);
        switch (sourceStatus) {
            case PASS: {
                destRow.setValue("passedRuns", (Object)(destRow.getInt("passedRuns") + 1));
                break;
            }
            case FAIL: {
                destRow.setValue("failedRuns", (Object)(destRow.getInt("failedRuns") + 1));
                break;
            }
            default: {
                destRow.setValue("skippedRuns", (Object)(destRow.getInt("skippedRuns") + 1));
            }
        }
    }

    protected String[] forColumns() {
        return new String[]{"status", "errorTypes", "errorMessages", "messages", "stacktrace", "totalRuns", "passedRuns", "failedRuns", "skippedRuns"};
    }
}

