/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.xunit.generator;

import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.xpath.XPathProcessor;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.xunit.generator.TestStatus;
import java.util.List;
import org.dom4j.Element;

public abstract class AbstractTestProcessor
extends XPathProcessor {
    private static final long serialVersionUID = 1L;

    public String getRootXPath() {
        return this.getXPathOfTestCase();
    }

    protected abstract String getXPathOfTestCase();

    public AbstractTestProcessor(ReportCategory category) {
        super(category);
        this.setId("parseTestReport");
    }

    protected void processCurrentElement() {
        GeneratorContext context = GeneratorContext.getContext();
        Element node = context.getCurrentElement();
        DataRow row = context.getDestRow();
        row.setValue("suiteName", (Object)this.getSuiteName(node));
        row.setValue("testName", (Object)this.getTestName(node));
        TestStatus status = this.getStatus(node);
        if (status == null) {
            status = TestStatus.SKIP;
        }
        row.setValue("status", (Object)status.name());
        row.setValue("duration", (Object)this.getDuration(node));
        row.setValue("errorTypes", this.getErrorTypes(node));
        row.setValue("errorMessages", this.getErrorMessages(node));
        row.setValue("messages", this.getMessages(node));
        row.setValue("totalRuns", (Object)1);
        switch (status) {
            case PASS: {
                row.setValue("passedRuns", (Object)1);
                break;
            }
            case FAIL: {
                row.setValue("failedRuns", (Object)1);
                break;
            }
            default: {
                row.setValue("skippedRuns", (Object)1);
            }
        }
    }

    protected abstract String getSuiteName(Element var1);

    protected abstract String getTestName(Element var1);

    protected abstract TestStatus getStatus(Element var1);

    protected abstract long getDuration(Element var1);

    protected abstract List<String> getErrorTypes(Element var1);

    protected abstract List<String> getErrorMessages(Element var1);

    protected abstract List<String> getMessages(Element var1);
}

