/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.xunit.aggregator;

import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.contribution.aggregation.ReportAggregator;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;

public abstract class XUnitAggregator
extends ReportAggregator {
    private static final long serialVersionUID = 1L;

    protected Class<? extends AbstractReportPlugin> getPluginClass() {
        Plugin plugin = PluginManager.instance.getDeclaringPlugin(((Object)((Object)this)).getClass());
        return plugin.getClass();
    }

    static void setSuccessRate(DataRow destRow) {
        int tests = destRow.getInt("tests");
        int failures = destRow.getInt("failures");
        double success_rate = MathUtils.divide((int)(tests - failures), (int)tests);
        destRow.setValue("success_rate", (Object)success_rate);
    }

    protected void aggregateOverview(DataRow sourceRow, DataRow destRow) {
        super.aggregateOverview(sourceRow, destRow);
        XUnitAggregator.setSuccessRate(destRow);
    }

    protected void updateStatsRow(DataRow destRow) {
        super.updateStatsRow(destRow);
        XUnitAggregator.setSuccessRate(destRow);
    }

    public ReportCategory getCategory() {
        return ReportHelper.getCategory(this.getPluginClass());
    }
}

