/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.xunit;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.AbstractProcessor;
import com.pmease.quickbuild.plugin.report.engine.generator.DefaultGenerator;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorStage;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.xunit.aggregator.XUnitAggregationOverviewRenderer;
import com.pmease.quickbuild.plugin.report.xunit.aggregator.XUnitAggregationStatsRenderer;
import com.pmease.quickbuild.plugin.report.xunit.generator.TestDiffProcessor;
import com.pmease.quickbuild.plugin.report.xunit.generator.TestDuplicateProcessor;
import com.pmease.quickbuild.plugin.report.xunit.renderer.BySuiteRenderer;
import com.pmease.quickbuild.plugin.report.xunit.renderer.ByTestRenderer;
import com.pmease.quickbuild.plugin.report.xunit.renderer.FailedTestRenderer;
import com.pmease.quickbuild.plugin.report.xunit.renderer.TestTrendsRenderer;
import com.pmease.quickbuild.plugin.report.xunit.renderer.XUnitDashboardRenderer;
import com.pmease.quickbuild.plugin.report.xunit.renderer.XUnitStatsRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class XUnitCategory
extends ReportCategory {
    private static final long serialVersionUID = 1L;

    public abstract String getName();

    protected abstract AbstractProcessor getTestProcessor();

    public XUnitCategory() {
        this.setId(this.getId());
        this.initFromClassResource(XUnitCategory.class);
        this.createGenerators();
        this.createRenderers();
        this.onInitialize();
    }

    public String getId() {
        return this.getName().toLowerCase().replaceAll(" ", "_");
    }

    public int getOrder() {
        return 500;
    }

    protected void onInitialize() {
    }

    protected void createGenerators() {
        ArrayList generators = Lists.newArrayList();
        generators.add(this.getTestGenerator());
        generators.addAll(this.generatorRepository.getGenerators());
        this.generatorRepository.setGenerators((List)generators);
    }

    protected void createRenderers() {
        this.addRenderer((AbstractRenderer)new FailedTestRenderer(this));
        this.addRenderer((AbstractRenderer)new BySuiteRenderer(this));
        this.addRenderer((AbstractRenderer)new ByTestRenderer(this));
        this.addRenderer((AbstractRenderer)new XUnitDashboardRenderer(this));
        this.addRenderer((AbstractRenderer)new XUnitStatsRenderer(this));
        this.addRenderer((AbstractRenderer)new TestTrendsRenderer(this));
        this.addRenderer((AbstractRenderer)new XUnitAggregationOverviewRenderer(this));
        this.addRenderer((AbstractRenderer)new XUnitAggregationStatsRenderer(this));
    }

    protected AbstractGenerator getTestGenerator() {
        DefaultGenerator generator = new DefaultGenerator((ReportCategory)this);
        generator.setId("generateTests");
        generator.setStage(GeneratorStage.BUILD);
        generator.setOrder(100);
        generator.setDestReportName("tests");
        AbstractProcessor p = this.getTestProcessor();
        if (Strings.isNullOrEmpty((String)p.getId())) {
            p.setId("generateTests");
        }
        if (p.getOrder() == 0) {
            p.setOrder(100);
        }
        generator.addProcessor(p);
        generator.addProcessor((AbstractProcessor)new TestDuplicateProcessor(this));
        generator.addProcessor((AbstractProcessor)new TestDiffProcessor(this));
        return generator;
    }
}

