/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.xunit;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationOverview;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryAggregationStatsTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;

public abstract class AbstractTestReportPlugin
extends AbstractReportPlugin {
    public Class<? extends Aggregation> getAggregatorClass() {
        return null;
    }

    protected String getAggregationStatsTabName() {
        return null;
    }

    public String getStatsTabName() {
        String str = this.getAggregationStatsTabName();
        if (Strings.isNullOrEmpty((String)str)) {
            ReportCategory category = this.getReportCategory();
            String name = category.getName();
            String[] array = (String[])Iterables.toArray((Iterable)Splitter.on((char)' ').omitEmptyStrings().split((CharSequence)name), String.class);
            Preconditions.checkArgument((array.length > 0 ? 1 : 0) != 0, (Object)"Category name is invalid. Seems empty?");
            return array[0] + " Aggregation";
        }
        return str;
    }

    protected Object[] getAggregationSupport() {
        if (this.getAggregatorClass() == null) {
            return new Object[0];
        }
        return new Object[]{new AggregationSupport(){

            public Class<? extends Aggregation> getAggregationClass() {
                return AbstractTestReportPlugin.this.getAggregatorClass();
            }

            public void cleanupAggregations(Configuration configuration) {
                ReportCategory category = AbstractTestReportPlugin.this.getReportCategory();
                category.deleteAllReportSetsOfAggregation(configuration);
            }
        }, new CategoryAggregationOverview(){

            protected ReportCategory getCategory() {
                return AbstractTestReportPlugin.this.getReportCategory();
            }

            protected String getToTab() {
                return Tab.title2id((String)AbstractTestReportPlugin.this.getStatsTabName());
            }
        }, new CategoryAggregationStatsTab(){
            private static final long serialVersionUID = 1L;

            protected String getTitle() {
                return AbstractTestReportPlugin.this.getStatsTabName();
            }

            public ReportCategory getCategory() {
                return AbstractTestReportPlugin.this.getReportCategory();
            }

            protected boolean isAggregationApplicable(Aggregation aggregation) {
                return aggregation.getClass().isAssignableFrom(AbstractTestReportPlugin.this.getAggregatorClass());
            }
        }};
    }
}

