/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.msbuild;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.builder.msbuild.CustomLoggerConsumer;
import com.pmease.quickbuild.plugin.builder.msbuild.LineConsumer;
import com.pmease.quickbuild.plugin.builder.msbuild.MSBuildCommand;
import com.pmease.quickbuild.plugin.builder.msbuild.MSBuildLoggerConsumer;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="MSBuild", category={"Build"}, description="Configure a MSBuild based build step here. By default, QuickBuild executes \"msbuild.exe\" to run this build step, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the MSBuild plugin through the plugin management page.")
@ScriptApi(value="This step calls MSBuild to build projects.")
public class MSBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String projectFile;
    private String targets;
    private List<Property> properties = new ArrayList<Property>();
    private String additionalSwitches;
    private List<Property> environments = new ArrayList<Property>();
    private boolean useSystemLogger = false;
    private String loggerParams;
    private transient int errors;
    private transient int warnings;
    private transient String errorInfo;
    private static final String LOGGER_DLL = "PMEase.QuickBuild.MSBuild.Logger.dll";

    public void run() {
        MSBuildCommand cmd;
        Log.LogLevel level = Context.getConfiguration().findLogLevel(this.getBuild());
        if (level.ordinal() < Log.LogLevel.DEBUG.ordinal()) {
            cmd = new MSBuildCommand();
            cmd.addArgLine("/ver");
            final StringBuffer sb = new StringBuffer();
            cmd.execute((OutputStream)new com.pmease.quickbuild.execution.LineConsumer(){

                public void consume(String line) {
                    sb.append(line).append("\n");
                }
            }, (com.pmease.quickbuild.execution.LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            Context.getLogger().debug("MSBuild version:\n\n" + sb.toString());
        }
        cmd = this.getBuildCommand();
        Environment env = new Environment();
        for (Property each : this.getActualEnvironments(this.getEnvironments())) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        LineConsumer consumer = this.getLineConsumer();
        Commandline.ExecuteResult result = cmd.execute(this.getActualWorkingDir(), env, (OutputStream)((Object)consumer), (com.pmease.quickbuild.execution.LineConsumer)new LineConsumer.ErrorLogger());
        int retCode = result.getReturnCode();
        this.errors = consumer.getTotalErrors();
        this.warnings = consumer.getTotalWarnings();
        this.errorInfo = consumer.getErrorInfo();
        if (retCode != 0 || consumer.isBuildFailed()) {
            StringBuffer sb = new StringBuffer("Executing below MSBuild command failed (").append(this.errors).append(" errors, ").append(this.warnings).append(" warnings):\n\t").append((Object)cmd);
            if (!StringUtils.isBlank((String)this.errorInfo)) {
                sb.append("\n\nSee detailed errors below:\n").append(this.errorInfo);
            } else {
                sb.append("\nSee detailed errors in the log");
            }
            throw new QuickbuildException(sb.toString());
        }
    }

    private LineConsumer getLineConsumer() {
        if (this.isUseSystemLogger()) {
            return new MSBuildLoggerConsumer();
        }
        return new CustomLoggerConsumer();
    }

    private MSBuildCommand getBuildCommand() {
        MSBuildCommand cmd = new MSBuildCommand();
        try {
            cmd.noLogo().setTargets(this.getTargets()).setProperties(this.getProperties());
            if (!this.isUseSystemLogger()) {
                cmd.addArgValue("/noconsolelogger");
                StringBuffer sb = new StringBuffer();
                sb.append("/l:QBLogger,").append(FileUtils.locateLib(MSBuildStep.class, (String)LOGGER_DLL).getAbsolutePath());
                if (!StringUtils.isEmpty((String)this.getLoggerParams())) {
                    sb.append(";").append(this.getLoggerParams());
                }
                sb.append(";v=").append(MSBuildCommand.Verbosity.fromLogLevel(Context.getConfiguration().findLogLevel(this.getBuild())).name().toLowerCase());
                cmd.addArgValue(sb.toString());
            } else {
                cmd.setVerbosity(Context.getConfiguration().findLogLevel(this.getBuild()));
            }
            if (!StringUtils.isEmpty((String)this.getAdditionalSwitches())) {
                cmd.addArgLine(this.getAdditionalSwitches());
            }
            cmd.setProjectFile(this.getActualProjectFile().getCanonicalPath());
        }
        catch (IOException e) {
            throw new QuickbuildException("Convert project file " + this.getActualProjectFile() + " to cannoical path failed!", (Throwable)e);
        }
        return cmd;
    }

    private File getActualProjectFile() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getProjectFile());
    }

    private File getActualWorkingDir() {
        File projectFile = this.getActualProjectFile();
        return projectFile.getParentFile();
    }

    @Editable(name="Project File", order=1000, description="Specify path to MSBuild project file. This argument also accepts Visual Studio solution files. A non-absolute path is considered to be relative to the workspace directory.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get MSBuild project file")
    public String getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    @Editable(name="Targets", order=1200, description="Optional specify the build targets. Separated by spaces.")
    @Scriptable
    @ScriptApi(value="Get the build targets")
    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    @Editable(name="Build Properties", order=1300, description="Sets or overrides the project-level properties. Properties specified here will be used as what the switch /property does.")
    @ScriptApi(value="Get the build properties")
    @Scriptable
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Editable(name="Additional Switches", order=1400, description="Specify additional command switches to MSBuild.exe. For example: /noautoresponse /maxcpucount:3. Reference <a target=\"_default\" href=\"http://msdn.microsoft.com/en-us/library/ms164311(v=VS.90).aspx\">MSBuild command line</a> page for available switches.")
    @ScriptApi(value="Get additional switches")
    @Scriptable
    public String getAdditionalSwitches() {
        return this.additionalSwitches;
    }

    public void setAdditionalSwitches(String extraSwitches) {
        this.additionalSwitches = extraSwitches;
    }

    @Editable(name="Environment Variables", order=2000, description="Specify environment variables for MSBuild execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Environment variables with blank value will be ignored.")
    @Advanced
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @Editable(name="Logger Parameters", order=2100, description="Optionally specify the logger parameters. The parameters will be applied when using QuickBuild logger. Below example will display the time spent in tasks, targets, and projects and hide the list of items and properties:<br/><code>PerformanceSummary;NoItemAndPropertyList</code> Reference <a href='http://msdn.microsoft.com/en-us/library/ms164311(v=VS.90).aspx' target='_default'>MSBuild Command Line</a> for available params.")
    @Advanced
    public String getLoggerParams() {
        return this.loggerParams;
    }

    public void setLoggerParams(String loggerParams) {
        this.loggerParams = loggerParams;
    }

    @Editable(name="Use MSBuild Logger", order=2200, description="Instead of using QuickBuild logger, use MSBuild logger or your own custom console logger. You may need specify the /logger switch in 'Additional Switches' field if you want to custom the logger.<br/><strong>NOTE:</strong>QuickBuild may not highlight the output correctly in this case.")
    @ScriptApi(value="Get whether use MSBuild logger or not.")
    @Advanced
    public boolean isUseSystemLogger() {
        return this.useSystemLogger;
    }

    public void setUseSystemLogger(boolean useSystemLogger) {
        this.useSystemLogger = useSystemLogger;
    }

    @ScriptApi(value="Get total errors found by MSBuild.")
    public int getTotalErrors() {
        return this.errors;
    }

    @ScriptApi(value="Get total warnings found by MSBuild.")
    public int getTotalWarnings() {
        return this.warnings;
    }

    @ScriptApi(value="Get error information found by MSBuild.")
    public String getErrorInfo() {
        return this.errorInfo;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element node = dom.getRootElement().element("workingDir");
        if (node != null) {
            node.detach();
        }
    }
}

