/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.msbuild;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.builder.msbuild.LineConsumer;
import com.pmease.quickbuild.plugin.builder.msbuild.consumerrule.ConsumerRule;
import com.pmease.quickbuild.plugin.builder.msbuild.consumerrule.RegexRule;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MSBuildLoggerConsumer
extends LineConsumer {
    private static final Pattern ERROR_MSG_PATTERN = Pattern.compile(".*: error (C|CS|MSB|VCBLD|BC)\\d+: ");
    private static final Pattern WARNING_MSG_PATTERN = Pattern.compile(".*: warning (C|CS|MSB|VCBLD|BC)\\d+: ");
    private static final Pattern TOTAL_WARNINGS_PATTERN = Pattern.compile("\\d+ Warning\\(s\\)");
    private static final Pattern TOTAL_ERRORS_PATTERN = Pattern.compile("\\d+ Error\\(s\\)");
    private static final ConsumerRule ERROR_MSG_RULE = new RegexRule(ERROR_MSG_PATTERN);
    private static final ConsumerRule WARNING_MSG_RULE = new RegexRule(WARNING_MSG_PATTERN);
    private static final ConsumerRule TOTAL_ERRORS_RULE = new RegexRule(TOTAL_ERRORS_PATTERN);
    private static final ConsumerRule TOTAL_WARNINGS_RULE = new RegexRule(TOTAL_WARNINGS_PATTERN);
    private static final ConsumerRule SUMMARY_RULE = new RegexRule(Pattern.compile("Build (FAILED|SUCCEEDED)"));
    private StringBuffer errorBuffer = new StringBuffer();
    private LoggerStage stage = LoggerStage.EVENT;

    private void processEventLine(String line) {
        if (ERROR_MSG_RULE.satisfied(line)) {
            this.log(line, Log.LogLevel.ERROR);
        } else if (WARNING_MSG_RULE.satisfied(line)) {
            this.log(line, Log.LogLevel.WARN);
        } else {
            this.log(line, Log.LogLevel.INFO);
        }
    }

    public void consume(String line) {
        switch (this.stage) {
            case EVENT: {
                if (SUMMARY_RULE.satisfied(line.trim())) {
                    this.log(line, Log.LogLevel.INFO);
                    if (line.contains("FAILED")) {
                        this.failed = true;
                    }
                    this.stage = LoggerStage.BULID_SUMMARY;
                    break;
                }
                this.processEventLine(line);
                break;
            }
            case BULID_SUMMARY: {
                if (TOTAL_WARNINGS_RULE.satisfied(line)) {
                    this.warnings = Integer.valueOf(StringUtils.split((String)line)[0].trim());
                    if (this.warnings > 0) {
                        this.log(line, Log.LogLevel.WARN);
                        break;
                    }
                    this.log(line, Log.LogLevel.INFO);
                    break;
                }
                if (TOTAL_ERRORS_RULE.satisfied(line)) {
                    this.errors = Integer.valueOf(StringUtils.split((String)line)[0].trim());
                    if (this.errors > 0) {
                        this.log(line, Log.LogLevel.ERROR);
                        break;
                    }
                    this.log(line, Log.LogLevel.INFO);
                    break;
                }
                if (line.startsWith("Time Elapsed")) {
                    this.log(line, Log.LogLevel.INFO);
                    break;
                }
                if (this.failed) {
                    this.log(line, Log.LogLevel.ERROR);
                    this.errorBuffer.append(line).append("\n");
                    break;
                }
                this.log(line, Log.LogLevel.INFO);
            }
        }
    }

    @Override
    public String getErrorInfo() {
        return this.errorBuffer.toString();
    }

    private static enum LoggerStage {
        EVENT,
        BULID_SUMMARY;

    }
}

