/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.msbuild;

import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.builder.msbuild.MSBuildPluginSetting;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MSBuildCommand
extends Commandline {
    public MSBuildCommand() {
        this.setExecutable(MSBuildPluginSetting.getMSBuildExecutable());
    }

    public MSBuildCommand noLogo() {
        this.addArgLine("/nologo");
        return this;
    }

    public MSBuildCommand setTargets(String targets) {
        if (!StringUtils.isEmpty((String)targets)) {
            String[] tokens = StringUtils.split((String)targets);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < tokens.length; ++i) {
                String each = StringUtils.stripEnd((String)tokens[i].trim(), (String)";");
                if (StringUtils.isEmpty((String)each)) continue;
                sb.append(each);
                if (i + 1 >= tokens.length) continue;
                sb.append(";");
            }
            this.addArgValue("/t:" + sb.toString());
        }
        return this;
    }

    public MSBuildCommand setProperties(List<Property> properties) {
        if (!properties.isEmpty()) {
            StringBuffer sb = new StringBuffer("/property:");
            int i = 0;
            for (Property each : properties) {
                sb.append(each.getName()).append("=").append(each.getValue());
                if (i + 1 < properties.size()) {
                    sb.append(";");
                }
                ++i;
            }
            this.addArgValue(sb.toString());
        }
        return this;
    }

    public MSBuildCommand setVerbosity(Log.LogLevel level) {
        return this.setVerbosity(Verbosity.fromLogLevel(level));
    }

    public MSBuildCommand setVerbosity(Verbosity v) {
        this.addArgValue("/v:" + v.name().toLowerCase());
        return this;
    }

    public MSBuildCommand setProjectFile(String projectFile) {
        this.addArgValue(projectFile);
        return this;
    }

    public static enum Verbosity {
        QUIET,
        MINIMAL,
        NORMAL,
        DETAILED,
        DIAGNOSTIC;


        public static Verbosity fromLogLevel(Log.LogLevel level) {
            switch (level) {
                case ERROR: {
                    return QUIET;
                }
                case WARN: {
                    return MINIMAL;
                }
                case INFO: {
                    return NORMAL;
                }
                case DEBUG: {
                    return DETAILED;
                }
                case TRACE: {
                    return DIAGNOSTIC;
                }
            }
            throw new IllegalArgumentException("Unable to convert logleve " + level + " to MSBuild verbosity type.");
        }
    }
}

