/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.msbuild;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.log.Log;
import org.apache.commons.lang.StringUtils;

public abstract class LineConsumer
extends com.pmease.quickbuild.execution.LineConsumer {
    protected boolean failed = false;
    protected int errors;
    protected int warnings;

    public abstract String getErrorInfo();

    protected void log(String line, Log.LogLevel level) {
        if (StringUtils.isBlank((String)line)) {
            Context.getLogger().info(line);
            return;
        }
        String actual = this.formatLine(line);
        switch (level) {
            case ERROR: {
                Context.getLogger().error(actual);
                break;
            }
            case WARN: {
                Context.getLogger().warn(actual);
                break;
            }
            case INFO: {
                Context.getLogger().info(actual);
                break;
            }
            case DEBUG: {
                Context.getLogger().debug(actual);
                break;
            }
            case TRACE: {
                Context.getLogger().trace(actual);
            }
        }
    }

    protected String formatLine(String line) {
        if (line.startsWith("  ")) {
            char c;
            int pos;
            for (pos = 0; pos < line.length() && (c = line.charAt(pos)) == ' '; ++pos) {
            }
            String spaces = line.substring(0, pos);
            String other = line.substring(pos);
            return spaces.replace("  ", "\t") + other;
        }
        return line;
    }

    public boolean isBuildFailed() {
        return this.failed;
    }

    public int getTotalErrors() {
        return this.errors;
    }

    public int getTotalWarnings() {
        return this.warnings;
    }
}

