/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.msbuild;

import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.builder.msbuild.LineConsumer;
import com.pmease.quickbuild.plugin.builder.msbuild.consumerrule.ConsumerRule;
import com.pmease.quickbuild.plugin.builder.msbuild.consumerrule.EqualsRule;
import com.pmease.quickbuild.plugin.builder.msbuild.consumerrule.RegexRule;
import com.pmease.quickbuild.plugin.builder.msbuild.consumerrule.StartWithRule;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CustomLoggerConsumer
extends LineConsumer {
    private static final ConsumerRule EVENT_RULE = new StartWithRule("QB_LOGEVENT:");
    private static final ConsumerRule ERROR_RULE = new RegexRule(Pattern.compile(".*: error MSB\\d+: "));
    private static final ConsumerRule PROPERTIES_RULE = new EqualsRule("Initial Properties:", true);
    private BuildEvent event = BuildEvent.UNKNOWN;
    private MessageImportance importance = MessageImportance.NORMAL;
    private StringBuffer errorBuffer = new StringBuffer();
    private boolean showProperties = false;
    private Stage stage = Stage.START;

    public void consume(String line) {
        if (EVENT_RULE.satisfied(line)) {
            this.stage = Stage.EVENT;
            this.updateVariables(line);
        } else if (this.stage == Stage.START) {
            if (ERROR_RULE.satisfied(line)) {
                ++this.errors;
                this.errorBuffer.append(line).append("\n");
                this.log(line, Log.LogLevel.ERROR);
            } else {
                this.log(line, Log.LogLevel.INFO);
            }
        } else {
            this.outputLine(line);
        }
    }

    private void updateVariables(String line) {
        String[] tokens = StringUtils.split((String)line, (char)':');
        try {
            if (this.event == BuildEvent.PROJECT_STARTED) {
                this.showProperties = false;
            }
            this.event = BuildEvent.valueOf(tokens[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.event = BuildEvent.UNKNOWN;
        }
        if (this.event == BuildEvent.MESSAGE_RAISED) {
            this.importance = MessageImportance.valueOf(tokens[2].toUpperCase());
        } else if (this.event == BuildEvent.BUILD_SUMMARY) {
            Map<String, String> map = this.parseParams(tokens[2]);
            this.failed = Boolean.valueOf(map.get("Succeeded").toUpperCase()) == false;
            this.errors = Integer.valueOf(map.get("TotalErrors"));
            this.warnings = Integer.valueOf(map.get("TotalWarnings"));
        }
    }

    private void outputLine(String line) {
        switch (this.event) {
            case ERROR_RAISED: {
                this.log(line, Log.LogLevel.ERROR);
                break;
            }
            case WARNING_RAISED: {
                this.log(line, Log.LogLevel.WARN);
                break;
            }
            case MESSAGE_RAISED: {
                if (this.importance == MessageImportance.LOW) {
                    this.log(line, Log.LogLevel.DEBUG);
                    break;
                }
                this.log(line, Log.LogLevel.INFO);
                break;
            }
            case PROJECT_STARTED: {
                if (this.showProperties) {
                    this.log(line, Log.LogLevel.DEBUG);
                    break;
                }
                if (PROPERTIES_RULE.satisfied(line)) {
                    this.log(line, Log.LogLevel.DEBUG);
                    this.showProperties = true;
                    break;
                }
                this.log(line, Log.LogLevel.INFO);
                break;
            }
            case BUILD_SUMMARY: {
                if (!this.failed) break;
                this.errorBuffer.append(line).append("\n");
                break;
            }
            default: {
                this.log(line, Log.LogLevel.INFO);
            }
        }
    }

    private Map<String, String> parseParams(String params) {
        String[] tokens;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String each : tokens = StringUtils.split((String)params, (String)";")) {
            String[] values = StringUtils.split((String)each, (String)"=");
            map.put(values[0].trim(), values.length < 2 ? null : values[1]);
        }
        return map;
    }

    @Override
    public String getErrorInfo() {
        return this.errorBuffer.toString();
    }

    private static enum Stage {
        START,
        EVENT;

    }

    private static enum MessageImportance {
        HIGH,
        NORMAL,
        LOW;

    }

    private static enum BuildEvent {
        BUILD_STARTED,
        BUILD_FINISHED,
        PROJECT_STARTED,
        PROJECT_FINISHED,
        TARGET_STARTED,
        TARGET_FINISHED,
        TASK_STARTED,
        TASK_FINISHED,
        MESSAGE_RAISED,
        ERROR_RAISED,
        WARNING_RAISED,
        CUSTOM_EVENT,
        BUILD_SUMMARY,
        UNKNOWN;

    }
}

