/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol;

import java.net.SocketAddress;
import net.sf.cindy.Message;
import net.sf.cindy.Session;
import net.sf.cindy.SessionAdapter;
import net.sf.cindy.SessionListener;
import net.sf.cindy.impl.SocketSession;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnMessageIterator;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnMessageChainImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnMessageRecognizer;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.TransactionId;
import net.sf.jml.protocol.WrapperMessage;
import net.sf.jml.protocol.incoming.IncomingQNG;
import net.sf.jml.util.JmlConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MsnSession {
    private static final Log log = LogFactory.getLog(MsnSession.class);
    private final SocketSession session = new SocketSession();
    private final MsnMessenger messenger;
    private final MsnSwitchboard switchboard;
    private final TransactionId trId = new TransactionId();
    private final MsnMessageChainImpl outgoingChain = new MsnMessageChainImpl(JmlConstants.MESSAGE_CHAIN_LENGTH);
    private final MsnMessageChainImpl incomingChain = new MsnMessageChainImpl(JmlConstants.MESSAGE_CHAIN_LENGTH);

    public MsnSession(MsnMessenger msnMessenger, SocketAddress socketAddress) {
        this.messenger = msnMessenger;
        this.switchboard = null;
        this.session.setSocketAddress(socketAddress);
        this.init();
    }

    public MsnSession(MsnSwitchboard msnSwitchboard, SocketAddress socketAddress) {
        this.messenger = msnSwitchboard.getMessenger();
        this.switchboard = msnSwitchboard;
        this.session.setSocketAddress(socketAddress);
        this.init();
    }

    private void init() {
        this.session.setAttachment(this);
        this.session.setMessageRecognizer(MsnMessageRecognizer.getInstance());
        this.session.addSessionListener(new SessionAdapter(){

            private String getConnectionType() {
                return MsnSession.this.switchboard == null ? "NS" : "SB (" + MsnSession.this.switchboard.getAttachment() + ")";
            }

            public void messageReceived(Session session, Message message) {
                if (MsnSession.this.messenger.isLogIncoming()) {
                    log.info(MsnSession.this.messenger.getOwner().getEmail() + " " + this.getConnectionType() + " <<< " + message.toString());
                }
                MsnIncomingMessage msnIncomingMessage = (MsnIncomingMessage)((WrapperMessage)message).getMessage();
                MsnSession.this.incomingChain.addMsnMessage(msnIncomingMessage);
                if (msnIncomingMessage.getTransactionId() > 0 || msnIncomingMessage instanceof IncomingQNG) {
                    int n = msnIncomingMessage.getTransactionId();
                    MsnMessageIterator msnMessageIterator = MsnSession.this.outgoingChain.iterator();
                    while (msnMessageIterator.hasPrevious()) {
                        MsnOutgoingMessage msnOutgoingMessage = (MsnOutgoingMessage)msnMessageIterator.previous();
                        if (msnOutgoingMessage.getTransactionId() != n) continue;
                        msnIncomingMessage.setOutgoingMessage(msnOutgoingMessage);
                        break;
                    }
                }
                try {
                    msnIncomingMessage.messageReceived(MsnSession.this);
                }
                catch (Exception exception) {
                    this.exceptionCaught(session, exception);
                }
                if (msnIncomingMessage.getOutgoingMessage() != null) {
                    try {
                        msnIncomingMessage.getOutgoingMessage().receivedResponse(MsnSession.this, msnIncomingMessage);
                    }
                    catch (Exception exception) {
                        this.exceptionCaught(session, exception);
                    }
                }
            }

            public void messageSent(Session session, Message message) {
                if (MsnSession.this.messenger.isLogOutgoing()) {
                    log.info(MsnSession.this.messenger.getOwner().getEmail() + " " + this.getConnectionType() + " >>> " + message.toString());
                }
                MsnOutgoingMessage msnOutgoingMessage = (MsnOutgoingMessage)((WrapperMessage)message).getMessage();
                MsnSession.this.outgoingChain.addMsnMessage(msnOutgoingMessage);
                try {
                    msnOutgoingMessage.messageSent(MsnSession.this);
                }
                catch (Exception exception) {
                    this.exceptionCaught(session, exception);
                }
            }

            public void exceptionCaught(Session session, Throwable throwable) {
                ((AbstractMessenger)MsnSession.this.messenger).fireExceptionCaught(throwable);
            }
        });
    }

    public MsnMessenger getMessenger() {
        return this.messenger;
    }

    public MsnSwitchboard getSwitchboard() {
        return this.switchboard;
    }

    public String getLocalAddress() {
        if (this.session.getChannel() != null) {
            return this.session.getChannel().socket().getLocalAddress().getHostAddress();
        }
        return null;
    }

    public int getLocalPort() {
        if (this.session.getChannel() != null) {
            return this.session.getChannel().socket().getLocalPort();
        }
        return -1;
    }

    public boolean isAvailable() {
        return this.session.isAvailable();
    }

    public void start() {
        this.session.start(false);
    }

    public void close() {
        this.session.close(false);
    }

    public void sendAsynchronousMessage(MsnOutgoingMessage msnOutgoingMessage) {
        if (msnOutgoingMessage != null) {
            if (msnOutgoingMessage.isSupportTransactionId()) {
                msnOutgoingMessage.setTransactionId(this.trId.nextTransactionId());
            }
            this.session.write(new WrapperMessage(msnOutgoingMessage));
        }
    }

    public boolean sendSynchronousMessage(MsnOutgoingMessage msnOutgoingMessage) {
        if (msnOutgoingMessage != null) {
            if (msnOutgoingMessage.isSupportTransactionId()) {
                msnOutgoingMessage.setTransactionId(this.trId.nextTransactionId());
            }
            return this.session.blockWrite(new WrapperMessage(msnOutgoingMessage));
        }
        return false;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.session.addSessionListener(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.session.removeSessionListener(sessionListener);
    }

    public MsnMessageChain getOutgoingMessageChain() {
        return this.outgoingChain;
    }

    public MsnMessageChain getIncomingMessageChain() {
        return this.incomingChain;
    }

    public void setSessionTimeout(int n) {
        this.session.setSessionTimeout(n);
    }
}

