/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.sf.jml.MsnObject;
import net.sf.jml.message.p2p.DisplayPictureDuel;

public class DisplayPictureDuelManager {
    private static final ScheduledExecutorService THREAD_EXECUTOR = Executors.newScheduledThreadPool(1);
    private List<DisplayPictureDuel> duels = new ArrayList<DisplayPictureDuel>();
    private Hashtable<String, RemovableMsnObject> pictures = new Hashtable();
    private MsnObject displayPicture;

    public DisplayPictureDuelManager() {
        THREAD_EXECUTOR.scheduleWithFixedDelay(new RemoveMsnObjectWorker(), 600L, 600L, TimeUnit.SECONDS);
    }

    public synchronized void add(DisplayPictureDuel displayPictureDuel) {
        this.duels.add(displayPictureDuel);
    }

    public synchronized DisplayPictureDuel get(int n) {
        for (DisplayPictureDuel displayPictureDuel : this.duels) {
            if (displayPictureDuel.getBaseId() != n) continue;
            return displayPictureDuel;
        }
        return null;
    }

    public synchronized boolean remove(int n) {
        DisplayPictureDuel displayPictureDuel = this.get(n);
        return this.duels.remove(displayPictureDuel);
    }

    public int getSize() {
        return this.duels.size();
    }

    public void putPicture(String string, MsnObject msnObject) {
        RemovableMsnObject removableMsnObject = new RemovableMsnObject(msnObject);
        this.pictures.put(string, removableMsnObject);
    }

    public MsnObject getPicture(String string) {
        RemovableMsnObject removableMsnObject = this.pictures.get(string);
        if (removableMsnObject != null) {
            return removableMsnObject.getMsnObject();
        }
        return this.getDisplayPicture();
    }

    public MsnObject getDisplayPicture() {
        return this.displayPicture;
    }

    public void setDisplayPicutre(MsnObject msnObject) {
        this.displayPicture = msnObject;
    }

    private class RemoveMsnObjectWorker
    implements Runnable {
        private RemoveMsnObjectWorker() {
        }

        public void run() {
            try {
                long l = Calendar.getInstance().getTimeInMillis();
                Iterator iterator = DisplayPictureDuelManager.this.pictures.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    RemovableMsnObject removableMsnObject = (RemovableMsnObject)entry.getValue();
                    if (removableMsnObject == null || l - removableMsnObject.getLastAccessedTime() <= 1200000L) continue;
                    iterator.remove();
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    class RemovableMsnObject {
        private MsnObject msnObject;
        private long lastAccessedTime;

        public RemovableMsnObject(MsnObject msnObject) {
            this.msnObject = msnObject;
            this.lastAccessedTime = Calendar.getInstance().getTimeInMillis();
        }

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public MsnObject getMsnObject() {
            this.lastAccessedTime = Calendar.getInstance().getTimeInMillis();
            return this.msnObject;
        }
    }
}

