/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.util.queue;

import net.sf.cindy.util.queue.BlockingQueue;
import net.sf.cindy.util.queue.QueueFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class QueueThread
extends Thread {
    private static final Log log = LogFactory.getLog(QueueThread.class);
    private final BlockingQueue queue = QueueFactory.createBlockingQueue();
    private final Object lockObject = new Object();
    private volatile boolean stop = false;

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void add(Object object) {
        this.queue.push(object);
    }

    public void clear() {
        this.queue.clear();
    }

    public int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block5: while (true) {
            try {
                while (true) {
                    Object object;
                    if (this.stop) {
                        object = this.lockObject;
                        synchronized (object) {
                            this.lockObject.notify();
                            break block5;
                        }
                    }
                    object = this.queue.pop();
                    if (object == null) continue;
                    this.action(object);
                }
            }
            catch (Throwable throwable) {
                log.error(throwable, throwable);
                continue;
            }
            break;
        }
        this.stop = true;
    }

    protected abstract void action(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingQueue stopRunImmediately() {
        Object object = this.lockObject;
        synchronized (object) {
            this.stop = true;
            this.interrupt();
            if (Thread.currentThread() != this) {
                try {
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.queue;
        }
    }
}

