/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import net.sf.cindy.Dispatcher;
import net.sf.cindy.EventGenerator;
import net.sf.cindy.Message;
import net.sf.cindy.MessageRecognizer;
import net.sf.cindy.Session;
import net.sf.cindy.SessionListener;
import net.sf.cindy.SessionStatistic;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.JmxProxySession;
import net.sf.cindy.impl.SessionMBean;
import net.sf.cindy.spi.SessionSpi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmxProxySessionFactory {
    private static final Log log = LogFactory.getLog(JmxProxySessionFactory.class);
    private static final String SESSION_ESTABLISHED = "cindy.sessionEstablished";
    private static final String SESSION_CLOSED = "cindy.sessionClosed";
    private static final String SESSION_TIMEOUT = "cindy.sessionTimeout";
    private static final String SESSION_IDLE = "cindy.sessionIdle";
    private static final String MESSAGE_RECEIVED = "cindy.messageReceived";
    private static final String MESSAGE_SENT = "cindy.messageSent";
    private static final String EXCEPTION_CAUGHT = "cindy.exceptionCaught";
    static /* synthetic */ Class class$net$sf$cindy$impl$SessionMBean;
    static /* synthetic */ Class class$net$sf$cindy$Session;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;

    public static JmxProxySession createJmxProxySession(Session session) {
        if (!Constants.SUPPORT_JMX_1_2 || !(session instanceof SessionSpi)) {
            return null;
        }
        try {
            return new JmxProxySessionImpl((SessionSpi)session);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            log.error(notCompliantMBeanException, notCompliantMBeanException);
            return null;
        }
    }

    private static class JmxProxySessionImpl
    extends StandardMBean
    implements JmxProxySession,
    SessionSpi,
    SessionMBean {
        private static final String[] ITEM_NAMES = new String[]{"ReceivedBytes", "SentBytes", "ElapsedTime", "AvgReceiveSpeed", "AvgSendSpeed", "ReceiveSpeed", "SendSpeed"};
        private static final String[] ITEM_DESCRIPTIONS = ITEM_NAMES;
        private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.DOUBLE};
        private static final CompositeType SESSION_STATISTIC_COMPOSITE_TYPE;
        private final SessionSpi session;
        private final SessionNotificationBroadcaster broadcaster = new SessionNotificationBroadcaster();

        public JmxProxySessionImpl(SessionSpi sessionSpi) throws NotCompliantMBeanException {
            super(class$net$sf$cindy$impl$SessionMBean == null ? (class$net$sf$cindy$impl$SessionMBean = JmxProxySessionFactory.class$("net.sf.cindy.impl.SessionMBean")) : class$net$sf$cindy$impl$SessionMBean);
            this.session = sessionSpi;
            sessionSpi.addSessionListener(this.broadcaster);
        }

        public Session getSession() {
            return this.session;
        }

        public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
            this.broadcaster.removeNotificationListener(notificationListener);
        }

        public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
            this.broadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
        }

        public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
            this.broadcaster.addNotificationListener(notificationListener, notificationFilter, object);
        }

        public MBeanNotificationInfo[] getNotificationInfo() {
            return this.broadcaster.getNotificationInfo();
        }

        protected synchronized void cacheMBeanInfo(MBeanInfo mBeanInfo) {
            MBeanInfo mBeanInfo2 = null;
            if (mBeanInfo != null) {
                String[] stringArray = new String[]{JmxProxySessionFactory.SESSION_ESTABLISHED, JmxProxySessionFactory.SESSION_CLOSED, JmxProxySessionFactory.SESSION_IDLE, JmxProxySessionFactory.SESSION_TIMEOUT, JmxProxySessionFactory.MESSAGE_RECEIVED, JmxProxySessionFactory.MESSAGE_SENT, JmxProxySessionFactory.EXCEPTION_CAUGHT};
                String string = (class$net$sf$cindy$Session == null ? (class$net$sf$cindy$Session = JmxProxySessionFactory.class$("net.sf.cindy.Session")) : class$net$sf$cindy$Session).getName();
                String string2 = "Session notification";
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                    if (!mBeanAttributeInfoArray[i].getName().equals("Statistic")) continue;
                    mBeanAttributeInfoArray[i] = new MBeanAttributeInfo(mBeanAttributeInfoArray[i].getName(), (class$javax$management$openmbean$CompositeData == null ? JmxProxySessionFactory.class$("javax.management.openmbean.CompositeData") : class$javax$management$openmbean$CompositeData).getName(), mBeanAttributeInfoArray[i].getDescription(), mBeanAttributeInfoArray[i].isReadable(), mBeanAttributeInfoArray[i].isWritable(), mBeanAttributeInfoArray[i].isIs());
                }
                mBeanInfo2 = new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanAttributeInfoArray, mBeanInfo.getConstructors(), mBeanInfo.getOperations(), new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, string, string2)});
            }
            super.cacheMBeanInfo(mBeanInfo2);
        }

        public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if (string.equals("Statistic")) {
                return this.statisticToCompositeData();
            }
            return super.getAttribute(string);
        }

        public AttributeList getAttributes(String[] stringArray) {
            AttributeList attributeList = super.getAttributes(stringArray);
            for (int i = 0; i < attributeList.size(); ++i) {
                if (!((Attribute)attributeList.get(i)).getName().equals("Statistic")) continue;
                Attribute attribute = new Attribute("Statistic", this.statisticToCompositeData());
                attributeList.set(i, attribute);
            }
            return attributeList;
        }

        private CompositeData statisticToCompositeData() {
            SessionStatistic sessionStatistic = this.session.getStatistic();
            if (sessionStatistic == null) {
                return null;
            }
            try {
                return new CompositeDataSupport(SESSION_STATISTIC_COMPOSITE_TYPE, ITEM_NAMES, new Object[]{sessionStatistic.getReceivedBytes(), sessionStatistic.getSentBytes(), sessionStatistic.getElapsedTime(), sessionStatistic.getAvgReceiveSpeed(), sessionStatistic.getAvgSendSpeed(), sessionStatistic.getReceiveSpeed(), sessionStatistic.getSendSpeed()});
            }
            catch (OpenDataException openDataException) {
                log.error(openDataException, openDataException);
                return null;
            }
        }

        public boolean getEnableStatistic() {
            return this.session.getEnableStatistic();
        }

        public void setEnableStatistic(boolean bl) {
            this.session.setEnableStatistic(bl);
        }

        public void setStatistic(SessionStatistic sessionStatistic) {
            this.session.setStatistic(sessionStatistic);
        }

        public void addSessionListener(SessionListener sessionListener) {
            this.session.addSessionListener(sessionListener);
        }

        public boolean blockWrite(Message message) throws IllegalArgumentException {
            return this.session.blockWrite(message);
        }

        public void close() {
            this.session.close();
        }

        public void close(boolean bl) {
            this.session.close(bl);
        }

        public void dispatchException(Throwable throwable) {
            this.session.dispatchException(throwable);
        }

        public Object getAttachment() {
            return this.session.getAttachment();
        }

        public int getBufferCapacityLimit() {
            return this.session.getBufferCapacityLimit();
        }

        public Dispatcher getDispatcher() {
            return this.session.getDispatcher();
        }

        public EventGenerator getEventGenerator() {
            return this.session.getEventGenerator();
        }

        public int getId() {
            return this.session.getId();
        }

        public MessageRecognizer getMessageRecognizer() {
            return this.session.getMessageRecognizer();
        }

        public int getSessionTimeout() {
            return this.session.getSessionTimeout();
        }

        public SessionStatistic getStatistic() {
            return this.session.getStatistic();
        }

        public int getWriteQueueSize() {
            return this.session.getWriteQueueSize();
        }

        public boolean isAvailable() {
            return this.session.isAvailable();
        }

        public boolean isClosing() {
            return this.session.isClosing();
        }

        public boolean isLogException() {
            return this.session.isLogException();
        }

        public boolean isStarted() {
            return this.session.isStarted();
        }

        public void onEvent(Object object, Object object2) {
            this.session.onEvent(object, object2);
        }

        public void removeSessionListener(SessionListener sessionListener) {
            this.session.removeSessionListener(sessionListener);
        }

        public void setAttachment(Object object) {
            this.session.setAttachment(object);
        }

        public void setBufferCapacityLimit(int n) {
            this.session.setBufferCapacityLimit(n);
        }

        public void setDispatcher(Dispatcher dispatcher) {
            this.session.setDispatcher(dispatcher);
        }

        public void setEventGenerator(EventGenerator eventGenerator) {
            this.session.setEventGenerator(eventGenerator);
        }

        public void setLogException(boolean bl) {
            this.session.setLogException(bl);
        }

        public void setMessageRecognizer(MessageRecognizer messageRecognizer) {
            this.session.setMessageRecognizer(messageRecognizer);
        }

        public void setSessionTimeout(int n) {
            this.session.setSessionTimeout(n);
        }

        public void start() throws IllegalStateException {
            this.session.start();
        }

        public void start(boolean bl) throws IllegalStateException {
            this.session.start(bl);
        }

        public void write(Message message) throws IllegalArgumentException {
            this.session.write(message);
        }

        static {
            CompositeType compositeType = null;
            try {
                compositeType = new CompositeType("cindy.sessionStatistic", "session statistic", ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            }
            catch (OpenDataException openDataException) {
                log.error(openDataException, openDataException);
            }
            SESSION_STATISTIC_COMPOSITE_TYPE = compositeType;
        }

        private class SessionNotificationBroadcaster
        extends NotificationBroadcasterSupport
        implements SessionListener {
            private long sequenceNumber = 1L;

            private SessionNotificationBroadcaster() {
            }

            private void sendNotification(Session session, String string, String string2) {
                this.sendNotification(new Notification(string, JmxProxySessionImpl.this, this.sequenceNumber++, System.currentTimeMillis(), string2));
            }

            public void exceptionCaught(Session session, Throwable throwable) {
                this.sendNotification(session, JmxProxySessionFactory.EXCEPTION_CAUGHT, throwable.toString());
            }

            public void messageReceived(Session session, Message message) {
                this.sendNotification(session, JmxProxySessionFactory.MESSAGE_RECEIVED, message.toString());
            }

            public void messageSent(Session session, Message message) {
                this.sendNotification(session, JmxProxySessionFactory.MESSAGE_SENT, message.toString());
            }

            public void sessionClosed(Session session) {
                this.sendNotification(session, JmxProxySessionFactory.SESSION_CLOSED, "");
            }

            public void sessionEstablished(Session session) {
                this.sendNotification(session, JmxProxySessionFactory.SESSION_ESTABLISHED, "");
            }

            public void sessionIdle(Session session) {
                this.sendNotification(session, JmxProxySessionFactory.SESSION_IDLE, "");
            }

            public void sessionTimeout(Session session) {
                this.sendNotification(session, JmxProxySessionFactory.SESSION_TIMEOUT, "");
            }
        }
    }
}

