/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.jabber;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="Global setting for Jabber notifier.")
public class JabberSetting {
    private String jabberServer = "talk.google.com";
    private int jabberPort = 5222;
    private String serviceName = "gmail.com";
    private String senderAccount;
    private String senderPassword;

    @Editable(order=100, description="Specify Jabber server which QuickBuild connects to and send messages. For example: <b>talk.google.com</b><br><strong>NOTE:</strong> Connecting through proxy is not yet supported.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get Jabber server.")
    public String getJabberServer() {
        return this.jabberServer;
    }

    public void setJabberServer(String jabberServer) {
        this.jabberServer = jabberServer;
    }

    @Editable(order=200, description="Specify jabber server port")
    @ScriptApi(value="Get jabber port.")
    public int getJabberPort() {
        return this.jabberPort;
    }

    public void setJabberPort(int jabberPort) {
        this.jabberPort = jabberPort;
    }

    @Editable(order=250, description="Specify jabber service name. If left empty, name of the jabber server will be used.")
    @Scriptable
    @ScriptApi(value="Get jabber service name. Null if use jabber server as service name.")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Editable(order=300, description="A Jabber account is needed to send out build notifications. For example, <em>quickbuild</em>.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get jabber account which is used to send Jabber notifications.")
    public String getSenderAccount() {
        return this.senderAccount;
    }

    public void setSenderAccount(String senderAccount) {
        this.senderAccount = senderAccount;
    }

    @Editable(order=400)
    @Password
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get Jabber password for the above Jabber account.")
    public String getSenderPassword() {
        return this.senderPassword;
    }

    public void setSenderPassword(String senderPassword) {
        this.senderPassword = senderPassword;
    }
}

