/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.jabber;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.AlarmManager;
import com.pmease.quickbuild.event.NodeAlertEvent;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.extensionpoint.SimpleNotifier;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.notifier.jabber.JabberNotificationTemplate;
import com.pmease.quickbuild.plugin.notifier.jabber.JabberPlugin;
import com.pmease.quickbuild.plugin.notifier.jabber.JabberSetting;
import com.pmease.quickbuild.plugin.notifier.jabber.JabberUserSetting;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class JabberNotifier
extends SimpleNotifier {
    public static final String GTALK_SERVICE = "gmail.com";
    private JabberPlugin plugin;

    public JabberNotifier(JabberPlugin plugin) {
        this.plugin = plugin;
    }

    public String getName() {
        return "Jabber/Google Talk";
    }

    private JabberSetting getSetting() {
        return (JabberSetting)this.plugin.getSetting(true);
    }

    private XMPPConnection connect() {
        JabberSetting setting = this.getSetting();
        String serviceName = setting.getServiceName() != null ? setting.getServiceName() : setting.getJabberServer();
        ConnectionConfiguration config = new ConnectionConfiguration(setting.getJabberServer(), setting.getJabberPort(), serviceName);
        XMPPConnection conn = null;
        try {
            conn = new XMPPConnection(config);
            SASLAuthentication.supportSASLMechanism((String)"PLAIN", (int)0);
            conn.connect();
            String senderAccount = setting.getSenderAccount();
            if (GTALK_SERVICE.equalsIgnoreCase(setting.getServiceName())) {
                if (senderAccount.indexOf("@") == -1) {
                    senderAccount = senderAccount + "@gmail.com";
                }
            } else if (senderAccount.indexOf("@") != -1) {
                senderAccount = StringUtils.substringBefore((String)senderAccount, (String)"@");
            }
            conn.login(senderAccount, setting.getSenderPassword());
            return conn;
        }
        catch (XMPPException e) {
            if (conn != null && conn.isConnected()) {
                conn.disconnect();
            }
            throw new RuntimeException(e);
        }
    }

    private void sendMessage(XMPPConnection conn, String to, String message) {
        Chat chat = conn.getChatManager().createChat(to, null);
        try {
            chat.sendMessage(message);
        }
        catch (XMPPException e) {
            Context.getLogger().error("Failed to send jabber message to '" + to + "'.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Set<User> users, Build build) {
        Context.push((Build)build);
        try {
            JabberNotificationTemplate template = (JabberNotificationTemplate)this.plugin.findConfigurationSetting(Context.getConfiguration(), true);
            if (template == null) {
                ScriptEngine scriptManager = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
                template = (JabberNotificationTemplate)scriptManager.installInterpolator((Object)new JabberNotificationTemplate());
            }
            if (!users.isEmpty()) {
                String message = VelocityUtils.evalTemplate((String)template.getContent(), (Map)Context.buildEvalContext((Object)template, null));
                this.notify(users, message);
            }
        }
        finally {
            Context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(Set<User> users, String message) {
        if (!users.isEmpty()) {
            JabberNotifier jabberNotifier = this;
            synchronized (jabberNotifier) {
                Context.getLogger().info("Connecting to jabber server '" + this.getSetting().getJabberServer() + "'...");
                XMPPConnection conn = this.connect();
                try {
                    for (User user : users) {
                        JabberUserSetting userSetting = (JabberUserSetting)this.plugin.getUserSetting(user, true);
                        Validate.notNull((Object)userSetting);
                        String jabberAccount = userSetting.getJabberAccount();
                        if (jabberAccount != null) {
                            Context.getLogger().debug("Sending Jabber message to '" + jabberAccount + "'...");
                            this.sendMessage(conn, jabberAccount, message);
                            continue;
                        }
                        Context.getLogger().warn("Can not send Jabber notification to user '" + user.getName() + "': Jabber account not specified.");
                    }
                }
                finally {
                    Context.getLogger().info("Disconnect from jabber server '" + this.getSetting().getJabberServer() + "'.");
                    conn.disconnect();
                }
            }
        }
    }

    public void notify(NodeAlertEvent event) {
        if (event.getAlerts().isEmpty()) {
            return;
        }
        Map map = AlarmManager.instance.getNotifierUsers((Notifier)this);
        if (map.isEmpty()) {
            return;
        }
        Set users = (Set)map.get(this.getName());
        if (users.isEmpty()) {
            return;
        }
        for (Alert each : event.getAlerts()) {
            this.notify((Set<User>)users, each.toString());
        }
    }
}

