/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.msn;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="Global setting for MSN notifier.")
public class MsnSetting {
    private String senderAccount;
    private String senderPassword;

    @Editable(order=100, description="QuickBuild needs a MSN Messenger account in order to send out build notifications. For example: <b>quickbuild@hotmail.com</b>.<br><strong>NOTE:</strong> Connecting through proxy is not yet supported.")
    @Email
    @NotEmpty
    @ScriptApi(value="Get the MSN account used to send MSN messages.")
    @Scriptable
    public String getSenderAccount() {
        return this.senderAccount;
    }

    public void setSenderAccount(String senderAccount) {
        this.senderAccount = senderAccount;
    }

    @Editable(order=200)
    @Password
    @NotEmpty
    @ScriptApi(value="Get the password for above MSN account.")
    @Scriptable
    public String getSenderPassword() {
        return this.senderPassword;
    }

    public void setSenderPassword(String senderPassword) {
        this.senderPassword = senderPassword;
    }
}

