/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.notifier.msn;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.entitymanager.AlarmManager;
import com.pmease.quickbuild.event.NodeAlertEvent;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.extensionpoint.SimpleNotifier;
import com.pmease.quickbuild.model.Alert;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.notifier.msn.MsnNotificationTemplate;
import com.pmease.quickbuild.plugin.notifier.msn.MsnPlugin;
import com.pmease.quickbuild.plugin.notifier.msn.MsnSetting;
import com.pmease.quickbuild.plugin.notifier.msn.MsnUserSetting;
import com.pmease.quickbuild.util.Single;
import com.pmease.quickbuild.util.VelocityUtils;
import java.util.Map;
import java.util.Set;
import net.sf.jml.Email;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.event.MsnAdapter;
import net.sf.jml.impl.MsnMessengerFactory;
import org.apache.commons.lang.Validate;

public class MsnNotifier
extends SimpleNotifier {
    private MsnPlugin plugin;

    public MsnNotifier(MsnPlugin plugin) {
        this.plugin = plugin;
    }

    private MsnSetting getSetting() {
        return (MsnSetting)this.plugin.getSetting(true);
    }

    public String getName() {
        return "MSN Messenger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Set<User> users, Build build) {
        Context.push((Build)build);
        try {
            MsnNotificationTemplate template = (MsnNotificationTemplate)this.plugin.findConfigurationSetting(Context.getConfiguration(), true);
            if (template == null) {
                ScriptEngine scriptManager = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
                template = (MsnNotificationTemplate)scriptManager.installInterpolator((Object)new MsnNotificationTemplate());
            }
            if (!users.isEmpty()) {
                String message = VelocityUtils.evalTemplate((String)template.getContent(), (Map)Context.buildEvalContext((Object)template, null));
                this.notify(users, message);
            }
        }
        finally {
            Context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(Set<User> users, String message) {
        if (!users.isEmpty()) {
            MsnNotifier msnNotifier = this;
            synchronized (msnNotifier) {
                MsnMessenger messenger = MsnMessengerFactory.createMsnMessenger((String)this.getSetting().getSenderAccount(), (String)this.getSetting().getSenderPassword());
                messenger.getOwner().setInitStatus(MsnUserStatus.ONLINE);
                final Single loginFlag = new Single((Object)false);
                messenger.addListener(new MsnAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void exceptionCaught(MsnMessenger messenger, Throwable throwable) {
                        Context.getLogger().error("Error while contacting MSN messenger.", throwable);
                        Single single = loginFlag;
                        synchronized (single) {
                            loginFlag.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void ownerStatusChanged(MsnMessenger messenger) {
                        if (messenger.getOwner().getStatus() == MsnUserStatus.ONLINE) {
                            Single single = loginFlag;
                            synchronized (single) {
                                loginFlag.setValue((Object)true);
                                loginFlag.notify();
                            }
                        }
                    }
                });
                Context.getLogger().info("Login to MSN messenger...");
                messenger.login();
                Single single = loginFlag;
                synchronized (single) {
                    try {
                        loginFlag.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!((Boolean)loginFlag.getValue()).booleanValue()) {
                    throw new QuickbuildException("Can not login to MSN messenger.");
                }
                try {
                    for (User user : users) {
                        MsnUserSetting userSetting = (MsnUserSetting)this.plugin.getUserSetting(user, true);
                        Validate.notNull((Object)userSetting);
                        if (userSetting.getMsnAccount() == null) {
                            Context.getLogger().warn("Can not send MSN messenger notification to user '" + user.getName() + "': MSN messenger account not specified.");
                            continue;
                        }
                        Email email = Email.parseStr((String)userSetting.getMsnAccount());
                        if (email == null) {
                            Context.getLogger().error("Can not send MSN messenger notification to user '" + user.getName() + "': MSN messenger account is invalid.");
                            continue;
                        }
                        Context.getLogger().debug("Sending MSN message to '" + email + "'...");
                        messenger.sendText(Email.parseStr((String)userSetting.getMsnAccount()), message);
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                finally {
                    Context.getLogger().info("Logout from MSN messenger.");
                    messenger.logout();
                }
            }
        }
    }

    public void notify(NodeAlertEvent event) {
        if (event.getAlerts().isEmpty()) {
            return;
        }
        Map map = AlarmManager.instance.getNotifierUsers((Notifier)this);
        if (map.isEmpty()) {
            return;
        }
        Set users = (Set)map.get(this.getName());
        if (users.isEmpty()) {
            return;
        }
        for (Alert each : event.getAlerts()) {
            this.notify((Set<User>)users, each.toString());
        }
    }
}

