/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.devenv;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.log.Log;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputConsumer
extends LineConsumer {
    private static final Logger logger = LoggerFactory.getLogger(OutputConsumer.class);
    public static final Pattern MSG_PATTERN = Pattern.compile(".*(fatal error|error|warning) (C|CS|MSB|VCBLD|BC|LNK)\\d+: ");
    private final Pattern SUMMARY_PATTERN;
    private int succeeded;
    private int failed;
    private int skipped;
    private List<String> errors = Lists.newArrayList();
    private List<String> warnings = Lists.newArrayList();

    public OutputConsumer(String buildType) {
        this.SUMMARY_PATTERN = OutputConsumer.getSummaryPattern(buildType);
    }

    public void consume(String line) {
        Log.LogLevel level = OutputConsumer.parseLogLevel(line);
        switch (level) {
            case ERROR: {
                OutputConsumer.getLogger().error(line);
                this.errors.add(line);
                break;
            }
            case WARN: {
                OutputConsumer.getLogger().warn(line);
                this.warnings.add(line);
                break;
            }
            default: {
                Matcher m = this.SUMMARY_PATTERN.matcher(line);
                if (m.find() && m.groupCount() >= 4) {
                    this.succeeded = Integer.valueOf(m.group(2));
                    this.failed = Integer.valueOf(m.group(3));
                    this.skipped = Integer.valueOf(m.group(4));
                }
                OutputConsumer.getLogger().info(line);
            }
        }
    }

    static Log.LogLevel parseLogLevel(String line) {
        Matcher m = MSG_PATTERN.matcher(line);
        Log.LogLevel level = Log.LogLevel.INFO;
        if (m.find() && m.groupCount() == 2) {
            String str = m.group(1);
            if (str.contains("error")) {
                return Log.LogLevel.ERROR;
            }
            if (str.equalsIgnoreCase("warning")) {
                return Log.LogLevel.WARN;
            }
        }
        return level;
    }

    private static Logger getLogger() {
        if (Quickbuild.getInstance() == null) {
            return logger;
        }
        return Context.getLogger();
    }

    public int getSucceeded() {
        return this.succeeded;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public String getErrors() {
        StringBuffer sb = new StringBuffer();
        int count = Math.min(5, this.errors.size());
        for (int i = 0; i < count; ++i) {
            sb.append(this.errors.get(i));
            if (i + 1 >= count) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<String> errors() {
        return this.errors;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    static Pattern getSummaryPattern(String buildType) {
        String str = "^========== " + buildType + "(.*): ";
        str = "Build".equalsIgnoreCase(buildType) ? str + "(\\d+) succeeded or up-to-date, " : str + "(\\d+) succeeded, ";
        str = str + "(\\d+) failed, (\\d+) skipped ==========$";
        return Pattern.compile(str);
    }
}

