/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.devenv;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Choices;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.builder.devenv.DevenvPluginSetting;
import com.pmease.quickbuild.plugin.builder.devenv.OutputConsumer;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.Environment;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Visual Studio Devenv", category={"Build"}, description="Configure a Visual Studio Devenv based build step here. By default, QuickBuild executes \"<b>devenv.com</b>\" to run this build step, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Devenv plugin through the plugin management page.")
@ScriptApi(value="This step calls Visual Studio Devenv to build projects.")
public class DevenvStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String project;
    private String workingDir;
    private String buildType = "Build";
    private String additionalSwitches;
    private List<Property> environments = new ArrayList<Property>();
    private transient int succeeded;
    private transient int failed;
    private transient int skipped;

    public void run() {
        Commandline cmd = new Commandline();
        cmd.setExecutable(DevenvPluginSetting.getDevenvExecutable());
        cmd.addArgLine(this.getProject());
        cmd.addArgLine("/" + this.getBuildType());
        if (!StringUtils.isEmpty((String)this.getAdditionalSwitches())) {
            cmd.addArgLine(this.getAdditionalSwitches());
        }
        Environment env = new Environment();
        for (Property each : this.getActualEnvironments(this.getEnvironments())) {
            if (!StringUtils.isNotBlank((String)each.getValue())) continue;
            Environment.Variable var = new Environment.Variable();
            var.setKey(each.getName());
            var.setValue(each.getValue());
            env.addVariable(var);
        }
        OutputConsumer consumer = new OutputConsumer(this.getBuildType());
        Commandline.ExecuteResult result = cmd.execute(this.getActualWorkingDir(), env, (OutputStream)((Object)consumer), (LineConsumer)new LineConsumer.ErrorLogger());
        this.succeeded = consumer.getSucceeded();
        this.failed = consumer.getFailed();
        this.skipped = consumer.getSkipped();
        if (result.getReturnCode() != 0) {
            StringBuffer sb = new StringBuffer("Executing below devenv command failed:\n").append("(").append(this.succeeded).append(" succeeded or up-to-date, ").append(this.failed).append(" failed, ").append(this.skipped).append(" skipped").append("). \n").append(cmd);
            String errors = consumer.getErrors();
            if (!StringUtils.isEmpty((String)errors)) {
                sb.append("\n\nSee detailed errors below:\n").append(errors);
            } else {
                sb.append("\n\nSee detailed erros in the build log");
            }
            throw new QuickbuildException(sb.toString());
        }
    }

    private File getActualWorkingDir() {
        File projectFile = FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getProject());
        return FileUtils.resolvePath((File)projectFile.getParentFile(), (String)this.getWorkingDir());
    }

    @Editable(name="Project to Build", order=1100, description="Specify path to the devenv solution or project file. A non-absolute path is considered to be relative to the workspace directory.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get project to build")
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Editable(name="Working Directory", order=1200, description="Optionally specify the working directory when executing the devenv command. A non-absolute path is considered to be relative to the workspace directory. If not specified, the workspace directory itself will be used.")
    @Scriptable
    @ScriptApi(value="Get working directory")
    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Editable(name="Build Type", order=1300, description="Specify how you want to build your project.")
    @NotEmpty
    @Choices(value={"Build", "Rebuild", "Clean", "Deploy"})
    @ScriptApi(value="Get the build type. The return value is one of \"Build\", \"Rebuild\", \"Clean\" and \"Deploy\".")
    public String getBuildType() {
        return this.buildType;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    @Editable(name="Additional Switches", order=1400, description="Specify additional command switches to execute devenv. Refer to <a target='_default' href='http://msdn.microsoft.com/en-us/library/xee0c8y7(v=VS.90).aspx'>Devenv Command Line Switches</a> for available switches.")
    public String getAdditionalSwitches() {
        return this.additionalSwitches;
    }

    public void setAdditionalSwitches(String additionalSwitches) {
        this.additionalSwitches = additionalSwitches;
    }

    @Editable(name="Environment Variables", order=2000, description="Specify environment variables for Devenv execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Environment variables with blank value will be ignored.")
    @Advanced
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @ScriptApi(value="Get number of succeeded projects")
    public int getSucceeded() {
        return this.succeeded;
    }

    @ScriptApi(value="Get number of failed projects")
    public int getFailed() {
        return this.failed;
    }

    @ScriptApi(value="Get number of skipped projects")
    public int getSkipped() {
        return this.skipped;
    }
}

