/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.builder.devenv;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.builder.devenv.DevenvPlugin;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import org.apache.commons.lang.StringUtils;

public class DevenvPluginSetting {
    private String exePath;

    @Editable(order=100, name="Devenv Executable Path", description="Specify path to devenv executable. For example: <b>C:\\Program Files\\Microsoft Visual Studio 9.0\\Common7\\IDE\\devenv.com</b>. If leave empty, devenv.com should be found on your system path.<div class='notice'>NOTE: Please specify <b>devenv.com</b> instead of <b>devenv.exe</b>, normally, they should exist in the same directory.</div>")
    @ScriptApi(value="Get Devenv executable path. Null if not specified.")
    @Scriptable
    public String getExePath() {
        return this.exePath;
    }

    public void setExePath(String exePath) {
        this.exePath = exePath;
    }

    public static String getDevenvExecutable() {
        DevenvPluginSetting setting = (DevenvPluginSetting)PluginSettingHelper.getSetting(DevenvPlugin.class, (boolean)true);
        String exe = setting.getExePath();
        if (StringUtils.isEmpty((String)exe)) {
            return "devenv";
        }
        return exe;
    }
}

