/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.versionbumper;

import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.dom4j.Element;

public class ProjectInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String key;
    private String version;
    private File file;
    private String parentKey;
    private String parentVersion;
    private Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private Set<String> references = new HashSet<String>();
    private boolean modified;

    public ProjectInfo(File file, Element projectElement, String replacePatterns) {
        Element dependenciesElement;
        this.file = file;
        this.key = projectElement.element("groupId").getText().trim() + ":" + projectElement.element("artifactId").getText().trim();
        this.version = projectElement.element("version").getText().trim();
        Element parentElement = projectElement.element("parent");
        if (parentElement != null) {
            this.parentKey = parentElement.elementText("groupId").trim() + ":" + parentElement.elementText("artifactId").trim();
            this.parentVersion = parentElement.elementText("version").trim();
        }
        if ((dependenciesElement = projectElement.element("dependencies")) != null) {
            for (Element element : dependenciesElement.elements()) {
                Element optionalElement;
                Element classifierElement;
                DependencyInfo dependency = new DependencyInfo();
                String dependencyKey = element.elementText("groupId").trim() + ":" + element.elementText("artifactId").trim();
                dependency.setVersion(element.elementText("version").trim());
                Element scopeElement = element.element("scope");
                if (scopeElement != null) {
                    dependency.setScope(scopeElement.getText().trim());
                }
                if ((classifierElement = element.element("classifier")) != null) {
                    dependency.setClassifier(classifierElement.getText().trim());
                }
                if ((optionalElement = element.element("optional")) != null) {
                    dependency.setOptional(optionalElement.getText().trim());
                }
                this.dependencies.put(dependencyKey, dependency);
            }
        }
        if (replacePatterns != null) {
            Pattern pattern = Pattern.compile("<groupId>(.*?)</groupId>\\s*<artifactId>(.*?)</artifactId>\\s*<version>.*?</version>");
            for (File each : FileUtils.listFiles((File)file.getParentFile(), (String)replacePatterns)) {
                String content = FileUtils.readFileAsString((File)each);
                Matcher matcher = pattern.matcher(content);
                while (matcher.find()) {
                    this.references.add(matcher.group(1) + ":" + matcher.group(2));
                }
            }
            this.references.removeAll(this.dependencies.keySet());
        }
    }

    public String getKey() {
        return this.key;
    }

    public File getFile() {
        return this.file;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public String getParentVersion() {
        return this.parentVersion;
    }

    public void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
    }

    public Map<String, DependencyInfo> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getReferences() {
        return this.references;
    }

    public void setReferences(Set<String> references) {
        this.references = references;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public static class DependencyInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String version;
        private String scope;
        private String classifier;
        private String optional;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getOptional() {
            return this.optional;
        }

        public void setOptional(String optional) {
            this.optional = optional;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DependencyInfo)) {
                return false;
            }
            DependencyInfo otherDependencyInfo = (DependencyInfo)other;
            return new EqualsBuilder().append((Object)this.getVersion(), (Object)otherDependencyInfo.getVersion()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.getVersion()).toHashCode();
        }
    }
}

