/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.versionbumper;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.versionbumper.ProjectInfo;
import com.pmease.quickbuild.plugin.versionbumper.Version;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.wicket.util.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.util.SerializationHelper;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Bump Plugin Versions", category={"Misc"}, description="This step bumps versions of changed QuickBuild plugins.")
public class BumpVersionStep
extends Step {
    private static final long serialVersionUID = 1L;
    private static final String BUMPER_COMMENT = "Version bumped by QuickBuild.";
    private String mvnPath;
    private String pomPatterns = "**/pom.xml";
    private String replacePatterns;

    @Editable(name="Maven Path", order=100)
    @Scriptable
    public String getMvnPath() {
        return this.mvnPath;
    }

    public void setMvnPath(String mvnPath) {
        this.mvnPath = mvnPath;
    }

    @Editable(order=200)
    @Scriptable
    @NotEmpty
    public String getPomPatterns() {
        return this.pomPatterns;
    }

    public void setPomPatterns(String pomPatterns) {
        this.pomPatterns = pomPatterns;
    }

    @Editable(order=300)
    @Scriptable
    public String getReplacePatterns() {
        return this.replacePatterns;
    }

    public void setReplacePatterns(String replacePatterns) {
        this.replacePatterns = replacePatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Map previousVersions;
        HashMap<String, ProjectInfo> projectInfos = new HashMap<String, ProjectInfo>();
        Collection pomFiles = FileUtils.listFiles((File)this.getBuild().getConfiguration().getWorkspaceDir(), (String)this.getPomPatterns());
        for (File file : pomFiles) {
            File tempFile = FileUtils.createTempFile((String)"bumpversion");
            try {
                ProjectInfo info;
                Commandline cmdline = new Commandline();
                if (this.getMvnPath() != null) {
                    cmdline.setExecutable(this.getMvnPath());
                } else {
                    cmdline.setExecutable("mvn");
                }
                cmdline.createArgument().setValue("help:effective-pom");
                cmdline.createArgument().setValue("-Doutput=" + tempFile.getAbsolutePath());
                cmdline.execute(file.getParentFile(), (OutputStream)new LineConsumer.InfoLogger(), (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                Document pom = new SAXReader().read(tempFile);
                if (pom.getRootElement().getName().equals("project")) {
                    info = new ProjectInfo(file, pom.getRootElement(), this.getReplacePatterns());
                    projectInfos.put(info.getKey(), info);
                    continue;
                }
                if (pom.getRootElement().getName().equals("projects")) {
                    info = new ProjectInfo(file, (Element)pom.getRootElement().elements().get(0), this.getReplacePatterns());
                    projectInfos.put(info.getKey(), info);
                    continue;
                }
                throw new QuickbuildException("Unrecognized pom format");
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            finally {
                FileUtils.deleteFile((File)tempFile);
            }
        }
        if (projectInfos.isEmpty()) {
            this.recordCurrentVersions(projectInfos);
            Context.getLogger().warn("No maven projects found in specified directory.");
            return;
        }
        String checkoutPath = null;
        for (ProjectInfo info : projectInfos.values()) {
            Iterator<Object> it = info.getDependencies().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ProjectInfo.DependencyInfo> entry = it.next();
                ProjectInfo keyInfo = (ProjectInfo)projectInfos.get(entry.getKey());
                if (keyInfo != null) {
                    if (keyInfo.getVersion().equals(entry.getValue().getVersion())) continue;
                    throw new QuickbuildException("Dependency to '" + entry.getKey() + "' in project '" + info.getKey() + "' should use version '" + keyInfo.getVersion() + "'.");
                }
                it.remove();
            }
            if (info.getParentKey() != null) {
                ProjectInfo keyInfo = (ProjectInfo)projectInfos.get(info.getParentKey());
                if (keyInfo != null) {
                    if (!keyInfo.getVersion().equals(info.getParentVersion())) {
                        throw new QuickbuildException("Project '" + info.getKey() + "' should use parent version '" + keyInfo.getVersion() + "'.");
                    }
                } else {
                    info.setParentKey(null);
                    info.setParentVersion(null);
                }
            }
            it = info.getReferences().iterator();
            while (it.hasNext()) {
                if (projectInfos.containsKey(it.next())) continue;
                it.remove();
            }
            checkoutPath = FileUtils.getRelativePath((String)info.getFile().getAbsolutePath(), (String)this.getBuild().getConfiguration().getWorkspaceDir().getAbsolutePath());
        }
        Map originProjectInfos = (Map)SerializationHelper.clone((Serializable)projectInfos);
        Validate.notNull(checkoutPath);
        Repository repository = null;
        for (Repository each : this.getBuild().getRepositories()) {
            String repositoryPath;
            SourceViewSupport svs = each.getSourceViewSupport();
            if (svs == null || (repositoryPath = svs.getRepositoryPath(checkoutPath)) == null) continue;
            repository = each;
            break;
        }
        if (repository == null) {
            throw new QuickbuildException("Unable to determine repository for path '" + checkoutPath + "'.");
        }
        Build previousSuccessful = this.getBuild().getPreviousSuccessful();
        if (previousSuccessful == null) {
            Context.getLogger().warn("Skipped version bumper as no previous successful build can be found.");
            this.recordCurrentVersions(projectInfos);
            return;
        }
        ArrayList<String> modifiedPaths = new ArrayList<String>();
        for (Changeset change : repository.getChangesSince(previousSuccessful)) {
            if (change.getComment().equals(BUMPER_COMMENT)) continue;
            for (Modification modification : change.getModifications()) {
                modifiedPaths.add(modification.getPath());
            }
        }
        boolean modified = false;
        block20: for (ProjectInfo info : projectInfos.values()) {
            checkoutPath = FileUtils.getRelativePath((String)info.getFile().getParentFile().getAbsolutePath(), (String)this.getBuild().getConfiguration().getWorkspaceDir().getAbsolutePath());
            String repositoryPath = null;
            SourceViewSupport svs = repository.getSourceViewSupport();
            if (svs != null) {
                repositoryPath = svs.getRepositoryPath(checkoutPath);
            }
            if (repositoryPath == null) {
                throw new QuickbuildException("Unable to find repository path for '" + checkoutPath + "'.");
            }
            for (String each : modifiedPaths) {
                if (FileUtils.getRelativePath((String)each, (String)repositoryPath) == null) continue;
                info.setModified(true);
                modified = true;
                continue block20;
            }
        }
        if (!modified) {
            this.recordCurrentVersions(projectInfos);
            return;
        }
        boolean changed = true;
        block22: while (changed) {
            changed = false;
            block23: for (ProjectInfo info : projectInfos.values()) {
                if (!info.isModified()) {
                    for (String each : info.getDependencies().keySet()) {
                        if (!((ProjectInfo)projectInfos.get(each)).isModified()) continue;
                        info.setModified(true);
                        changed = true;
                        break;
                    }
                }
                if (!info.isModified() && info.getParentKey() != null && ((ProjectInfo)projectInfos.get(info.getParentKey())).isModified()) {
                    info.setModified(true);
                    changed = true;
                    continue block22;
                }
                if (info.isModified()) continue;
                for (String each : info.getReferences()) {
                    if (!((ProjectInfo)projectInfos.get(each)).isModified()) continue;
                    info.setModified(true);
                    changed = true;
                    continue block23;
                }
            }
        }
        ServerService serverService = Quickbuild.getServerService();
        String publishDir = serverService.getBuildPublishDir(previousSuccessful.getId());
        String srcFile = publishDir + "/versionbumper";
        if (!Grid.instance.getServerNode().isFileExists(srcFile)) {
            this.recordCurrentVersions(projectInfos);
            return;
        }
        File tempFile = FileUtils.createTempFile((String)"bumpversion");
        try {
            Grid.instance.transferFile(Grid.instance.getServerNode(), srcFile, Grid.instance.getLocalNode(), tempFile.getAbsolutePath(), null, null);
            previousVersions = (Map)FileUtils.readFileAsObject((File)tempFile);
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
        ArrayList<Version> versionCandidates = new ArrayList<Version>();
        for (Map.Entry entry : projectInfos.entrySet()) {
            if (((ProjectInfo)entry.getValue()).isModified()) {
                String previousVersion;
                String currentVersion = ((ProjectInfo)entry.getValue()).getVersion();
                if (currentVersion.equals(previousVersion = (String)previousVersions.get(entry.getKey()))) {
                    Version version = new Version(currentVersion);
                    version.increase();
                    ((ProjectInfo)entry.getValue()).setVersion(version.toString());
                } else {
                    ((ProjectInfo)entry.getValue()).setModified(false);
                }
            }
            versionCandidates.add(new Version(((ProjectInfo)entry.getValue()).getVersion()));
        }
        String maxVersion = ((Version)Collections.max(versionCandidates)).toString();
        for (ProjectInfo info : projectInfos.values()) {
            if (!info.isModified()) continue;
            info.setVersion(maxVersion);
        }
        for (ProjectInfo info : projectInfos.values()) {
            for (Map.Entry<String, ProjectInfo.DependencyInfo> entry : info.getDependencies().entrySet()) {
                ProjectInfo keyInfo = (ProjectInfo)projectInfos.get(entry.getKey());
                Validate.notNull((Object)keyInfo);
                entry.getValue().setVersion(keyInfo.getVersion());
            }
            if (info.getParentKey() == null) continue;
            info.setParentVersion(((ProjectInfo)projectInfos.get(info.getParentKey())).getVersion());
        }
        repository.switchToHead();
        boolean shouldCommit = false;
        for (ProjectInfo info : projectInfos.values()) {
            ProjectInfo originInfo = (ProjectInfo)originProjectInfos.get(info.getKey());
            if (info.getVersion().equals(originInfo.getVersion()) && ObjectUtils.equals((Object)info.getParentVersion(), (Object)originInfo.getParentVersion()) && ((Object)info.getDependencies()).equals(originInfo.getDependencies())) continue;
            shouldCommit = true;
            try {
                Element element;
                Document pom = new SAXReader().read(info.getFile());
                if (!info.getVersion().equals(info.getParentVersion())) {
                    if (!info.getVersion().equals(originInfo.getVersion())) {
                        element = pom.getRootElement().element("version");
                        if (element != null) {
                            element.setText(info.getVersion());
                        } else {
                            pom.getRootElement().addElement("version").setText(info.getVersion());
                        }
                    }
                    if (!ObjectUtils.equals((Object)info.getParentVersion(), (Object)originInfo.getParentVersion())) {
                        Element parentElement = pom.getRootElement().element("parent");
                        parentElement.element("version").setText(info.getParentVersion());
                    }
                } else {
                    element = pom.getRootElement().element("version");
                    if (element != null) {
                        element.detach();
                    }
                    Element parentElement = pom.getRootElement().element("parent");
                    parentElement.element("version").setText(info.getParentVersion());
                }
                if (!((Object)info.getDependencies()).equals(originInfo.getDependencies())) {
                    HashMap<String, Element> elements = new HashMap<String, Element>();
                    Element dependenciesElement = pom.getRootElement().element("dependencies");
                    if (dependenciesElement != null) {
                        for (Element element2 : dependenciesElement.elements()) {
                            String dependencyKey = element2.elementText("groupId").trim() + ":" + element2.elementText("artifactId").trim();
                            elements.put(dependencyKey, element2);
                        }
                    }
                    for (Map.Entry entry : info.getDependencies().entrySet()) {
                        ProjectInfo.DependencyInfo originDependency = originInfo.getDependencies().get(entry.getKey());
                        Validate.notNull((Object)originDependency);
                        if (((ProjectInfo.DependencyInfo)entry.getValue()).getVersion().equals(originDependency.getVersion())) continue;
                        Element element3 = (Element)elements.get(entry.getKey());
                        if (element3 != null) {
                            Element versionElement = element3.element("version");
                            if (versionElement != null) {
                                versionElement.setText(((ProjectInfo.DependencyInfo)entry.getValue()).getVersion());
                                continue;
                            }
                            element3.addElement("version").setText(((ProjectInfo.DependencyInfo)entry.getValue()).getVersion());
                            continue;
                        }
                        dependenciesElement = pom.getRootElement().element("dependencies");
                        if (dependenciesElement == null) {
                            dependenciesElement = pom.getRootElement().addElement("dependencies");
                        }
                        Element dependencyElement = dependenciesElement.addElement("dependency");
                        dependencyElement.addElement("groupId").setText(StringUtils.substringBefore((String)((String)entry.getKey()), (String)":"));
                        dependencyElement.addElement("artifactId").setText(StringUtils.substringAfter((String)((String)entry.getKey()), (String)":"));
                        dependencyElement.addElement("version").setText(((ProjectInfo.DependencyInfo)entry.getValue()).getVersion());
                        if (((ProjectInfo.DependencyInfo)entry.getValue()).getClassifier() != null) {
                            dependencyElement.addElement("classifier").setText(((ProjectInfo.DependencyInfo)entry.getValue()).getClassifier());
                        }
                        if (((ProjectInfo.DependencyInfo)entry.getValue()).getScope() != null) {
                            dependencyElement.addElement("scope").setText(((ProjectInfo.DependencyInfo)entry.getValue()).getScope());
                        }
                        if (((ProjectInfo.DependencyInfo)entry.getValue()).getOptional() == null) continue;
                        dependencyElement.addElement("optional").setText(((ProjectInfo.DependencyInfo)entry.getValue()).getOptional());
                    }
                }
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(info.getFile());
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setIndentSize(4);
                    XMLWriter writer = new XMLWriter((OutputStream)os, format);
                    writer.write(pom);
                    writer.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)os);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getReplacePatterns() != null) {
            Collection replaceFiles = FileUtils.listFiles((File)this.getBuild().getConfiguration().getWorkspaceDir(), (String)this.getReplacePatterns());
            for (File file : replaceFiles) {
                String originContent;
                String content = originContent = FileUtils.readFileAsString((File)file);
                for (ProjectInfo projectInfo : projectInfos.values()) {
                    String string = StringUtils.substringBefore((String)projectInfo.getKey(), (String)":");
                    String artifactId = StringUtils.substringAfter((String)projectInfo.getKey(), (String)":");
                    content = content.replaceAll("(<groupId>" + string + "</groupId>\\s*<artifactId>" + artifactId + "</artifactId>\\s*<version>).*?(</version>)", "$1" + projectInfo.getVersion() + "$2");
                }
                if (content.equals(originContent)) continue;
                FileUtils.writeFile((File)file, (String)content);
                shouldCommit = true;
            }
        }
        if (shouldCommit) {
            repository.commit(BUMPER_COMMENT);
        }
        this.recordCurrentVersions(projectInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordCurrentVersions(Map<String, ProjectInfo> projectInfos) {
        HashMap<String, String> currentVersions = new HashMap<String, String>();
        for (Map.Entry<String, ProjectInfo> entry : projectInfos.entrySet()) {
            currentVersions.put(entry.getKey(), entry.getValue().getVersion());
        }
        ServerService serverService = Quickbuild.getServerService();
        String publishDir = serverService.getBuildPublishDir(this.getBuild().getId());
        String destFile = publishDir + "/versionbumper";
        File tempFile = FileUtils.createTempFile((String)"bumpversion");
        try {
            FileUtils.writeFile((File)tempFile, (Serializable)currentVersions);
            Grid.instance.transferFile(Grid.instance.getLocalNode(), tempFile.getAbsolutePath(), Grid.instance.getServerNode(), destFile, null, null);
        }
        finally {
            FileUtils.deleteFile((File)tempFile);
        }
        ArrayList<Version> versions = new ArrayList<Version>();
        for (String value : currentVersions.values()) {
            versions.add(new Version(value));
        }
        this.getBuild().setVersion(((Version)Collections.max(versions)).toString());
    }
}

