/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.versionbumper;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.component.datatablesupport.DataProvider;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ArtifactVersionPanel
extends Panel {
    public ArtifactVersionPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        final ArrayList<Artifact> versions = new ArrayList<Artifact>();
        File versionsFile = new File(Context.getBuild().getPublishDir(), "versionbumper");
        if (versionsFile.exists()) {
            for (Map.Entry entry : ((Map)FileUtils.readFileAsObject((File)versionsFile)).entrySet()) {
                Artifact version = new Artifact();
                version.setName((String)entry.getKey());
                version.setVersion((String)entry.getValue());
                versions.add(version);
            }
        }
        Collections.sort(versions, new Comparator<Artifact>(){

            @Override
            public int compare(Artifact artifact1, Artifact artifact2) {
                return artifact1.getName().compareTo(artifact2.getName());
            }
        });
        ArrayList<AbstractColumn> columns = new ArrayList<AbstractColumn>();
        columns.add(new AbstractColumn<Artifact>((IModel)new Model((Serializable)((Object)"Artifact"))){

            public void populateItem(Item<ICellPopulator<Artifact>> cellItem, String componentId, IModel<Artifact> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((Artifact)rowModel.getObject()).getName())});
            }
        });
        columns.add(new AbstractColumn<Artifact>((IModel)new Model((Serializable)((Object)"Version"))){

            public void populateItem(Item<ICellPopulator<Artifact>> cellItem, String componentId, IModel<Artifact> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, ((Artifact)rowModel.getObject()).getVersion())});
            }
        });
        this.add(new Component[]{new DefaultDataTable("versions", columns, (ISortableDataProvider)new DataProvider(){

            public Iterator<? extends Artifact> iterator(int first, int count) {
                return versions.iterator();
            }

            public int size() {
                return versions.size();
            }
        }, Integer.MAX_VALUE)});
    }

    private static class Artifact
    implements Serializable {
        private String name;
        private String version;

        private Artifact() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

