/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import org.apache.commons.lang.StringUtils;

public enum UserSchema {
    AuthorName("Author Name"),
    AuthorEmail("Author Email"),
    CommitterName("Committer Name"),
    CommitterEmail("Committer Email"),
    AuthorNameAndEmail("Author Name and Email"),
    CommitterNameAndEmail("Committer Name and Email");

    private final String displayName;

    private UserSchema(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static UserSchema fromDisplayName(String value) {
        if (StringUtils.isEmpty((String)value)) {
            throw new IllegalArgumentException("User schema can't be null");
        }
        for (UserSchema each : UserSchema.values()) {
            if (!each.getDisplayName().equals(value)) continue;
            return each;
        }
        throw new IllegalArgumentException("Unknown user schema " + value);
    }

    public static boolean useAuthor(UserSchema schema) {
        return schema == AuthorName || schema == AuthorEmail || schema == AuthorNameAndEmail;
    }
}

