/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import com.pmease.quickbuild.plugin.scm.helper.CommitterUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class PersonIdent {
    private final String name;
    private final String emailAddress;
    private final long when;
    private final int tzOffset;

    public PersonIdent(String name, String email, String time, String timezone) {
        this.name = name.trim();
        this.emailAddress = email.trim();
        this.when = Long.parseLong(time.trim()) * 1000L;
        if (StringUtils.isBlank((String)timezone)) {
            this.tzOffset = 0;
        } else {
            int tzMins;
            int tzHours;
            if ((timezone = timezone.trim()).charAt(0) == '+') {
                tzHours = Integer.parseInt(timezone.substring(1, 3));
                tzMins = Integer.parseInt(timezone.substring(3));
            } else if (timezone.charAt(0) == '-') {
                tzHours = Integer.parseInt(timezone.substring(0, 3));
                tzMins = Integer.parseInt(timezone.substring(3));
            } else {
                tzHours = Integer.parseInt(timezone.substring(0, 2));
                tzMins = Integer.parseInt(timezone.substring(2));
            }
            this.tzOffset = tzHours * 60 + tzMins;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Date getWhen() {
        return new Date(this.when);
    }

    public String getFullCommitterName() {
        return CommitterUtils.createFullCommitter((String)this.name, (String)this.emailAddress);
    }

    public TimeZone getTimeZone() {
        StringBuilder tzId = new StringBuilder(8);
        tzId.append("GMT");
        this.appendTimezone(tzId);
        return TimeZone.getTimeZone(tzId.toString());
    }

    public int getTimeZoneOffset() {
        return this.tzOffset;
    }

    public int hashCode() {
        return this.getEmailAddress().hashCode() ^ (int)this.when;
    }

    public boolean equals(Object o) {
        if (o instanceof PersonIdent) {
            PersonIdent p = (PersonIdent)o;
            return this.getName().equals(p.getName()) && this.getEmailAddress().equals(p.getEmailAddress()) && this.when == p.when;
        }
        return false;
    }

    public String toExternalString() {
        StringBuilder r = new StringBuilder();
        r.append(this.getName());
        r.append(" <");
        r.append(this.getEmailAddress());
        r.append("> ");
        r.append(this.when / 1000L);
        r.append(' ');
        this.appendTimezone(r);
        return r.toString();
    }

    private void appendTimezone(StringBuilder r) {
        char sign;
        int offset = this.tzOffset;
        if (offset < 0) {
            sign = '-';
            offset = -offset;
        } else {
            sign = '+';
        }
        int offsetHours = offset / 60;
        int offsetMins = offset % 60;
        r.append(sign);
        if (offsetHours < 10) {
            r.append('0');
        }
        r.append(offsetHours);
        if (offsetMins < 10) {
            r.append('0');
        }
        r.append(offsetMins);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        SimpleDateFormat dtfmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z");
        dtfmt.setTimeZone(this.getTimeZone());
        r.append("PersonIdent[");
        r.append(this.getName());
        r.append(", ");
        r.append(this.getEmailAddress());
        r.append(", ");
        r.append(dtfmt.format(this.when));
        r.append("]");
        return r.toString();
    }

    public static void main(String[] args) {
        PersonIdent ident = new PersonIdent("steve", "steve@pmease.com", "1281215991", "+0800");
        System.out.println(ident.getTimeZone());
        System.out.println(ident);
    }
}

