/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.scm.git.GitCli;
import com.pmease.quickbuild.plugin.scm.git.GitRepository;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GitSourceViewSupport
extends SourceViewSupport<GitRevision> {
    public GitSourceViewSupport(GitRepository repository) {
        super((Repository)repository);
    }

    public String getRepositoryPath(String checkoutPath) {
        String relativePath;
        try {
            File checkoutFile = new File(Context.getConfiguration().getWorkspaceDir(), checkoutPath);
            String checkoutFileCanonicalPath = checkoutFile.getCanonicalPath();
            String destDirCanonicalPath = this.getRepository().getWorkingDir().getCanonicalPath();
            Context.getLogger().debug("Calculating repository path...");
            Context.getLogger().debug("Path to checkout file: " + checkoutFileCanonicalPath);
            Context.getLogger().debug("Path to repository destination directory: " + destDirCanonicalPath);
            relativePath = FileUtils.getRelativePath((String)checkoutFile.getCanonicalPath(), (String)this.getRepository().getWorkingDir().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (relativePath == null || relativePath.length() == 0) {
            return null;
        }
        relativePath = StringUtils.stripStart((String)relativePath, (String)"/");
        return relativePath;
    }

    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        return new GitCli(this.getRepository()).show(repositoryPath, new GitRevision(edition));
    }

    public List<String> readSourceByRevision(String repositoryPath, GitRevision revision) {
        return new GitCli(this.getRepository()).show(repositoryPath, revision);
    }

    public GitRepository getRepository() {
        return (GitRepository)super.getRepository();
    }
}

