/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.plugin.scm.git.GitCli;
import com.pmease.quickbuild.plugin.scm.git.GitPluginSetting;
import com.pmease.quickbuild.plugin.scm.git.GitProofBuildSupport;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.plugin.scm.git.GitSourceViewSupport;
import com.pmease.quickbuild.plugin.scm.git.GitUrl;
import com.pmease.quickbuild.plugin.scm.git.UserSchema;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.CommitterUtils;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.repositorysupport.WorkingDirLocator;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Git", description="Configure a Git repository here. By default, QuickBuild executes \"git\" to pull changes from the repository, and expects this file to be on the system path. If not, you will need to specify path to this file by configuring the Git plugin through the plugin management page.")
@ScriptApi
public class GitRepository
extends AbstractRepository<GitRevision> {
    private static final long serialVersionUID = 1L;
    private String fetchUrl;
    private String pushUrl;
    private String userName;
    private String password;
    private String destPath;
    private String buildRevision;
    private String branch;
    private String userSchema = "Author Name";
    private boolean enableSubmodule = false;
    private GitProofBuildSupport proofBuildSupport;
    private String referenceRepoPath;
    @XStreamOmitField
    private Set<String> syncedNodes;
    private static final String DOT_GIT = ".git";
    public static final String FETCH_URL = "fetchurl";
    public static final String PUSH_URL = "pushurl";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String BRANCH = "branch";
    public static final String REFERENCE = "reference";

    protected void checkoutByRevision(GitRevision revision) {
        this.getGit().checkout(revision.toString());
    }

    protected List<Changeset> getChangesBetween(GitRevision startRevision, GitRevision endRevision) {
        try {
            List<Changeset> changes = this.getGit().changesBetween(startRevision, endRevision);
            Iterator<Changeset> it = changes.iterator();
            while (it.hasNext()) {
                Changeset c = it.next();
                if (!c.getId().equals(startRevision.getValue())) continue;
                it.remove();
            }
            return changes;
        }
        catch (Exception e) {
            if (ExceptionUtils.extractImportantMessage((Throwable)e).contains("fatal: bad object")) {
                Context.getLogger().error(String.format("Error calculating changes between commit %s and %s", startRevision.getValue(), endRevision.getValue()), (Throwable)e);
                return new ArrayList<Changeset>();
            }
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public void commit(String comment) {
        this.getGit().commit(comment).push(null);
    }

    public void switchToHead() {
        this.getGit().switchToHead(this.getBranch() != null ? this.getBranch() : "master");
    }

    protected GitRevision getHeadRevision() {
        GitCli git = this.getGit();
        if (StringUtils.isEmpty((String)this.getBuildRevision())) {
            return git.revision("FETCH_HEAD");
        }
        return git.revision(this.getBuildRevision());
    }

    public SourceViewSupport<GitRevision> getSourceViewSupport() {
        return new WorkingDirLocator((SourceViewSupport)new GitSourceViewSupport(this));
    }

    protected boolean isQuietSince(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<Changeset> changes = this.getGit().changes("-1 --since=\"" + fmt.format(date) + "\"");
        return changes.isEmpty();
    }

    protected void labelOnRevision(GitRevision revision, String label, String comment) {
        this.getGit().tagRemote(revision, label, comment);
    }

    private String getActualUrl(String url, boolean descriptive) {
        GitUrl scmUrl = new GitUrl(url, this.getUserName(), this.getPassword());
        if (descriptive) {
            return scmUrl.toDescriptiveString();
        }
        return scmUrl.toString();
    }

    public String getActualFetchUrl(boolean descriptive) {
        return this.getActualUrl(this.getFetchUrl(), descriptive);
    }

    public String getActualPushUrl(boolean descriptive) {
        if (StringUtils.isEmpty((String)this.getPushUrl())) {
            return this.getActualFetchUrl(descriptive);
        }
        return this.getActualUrl(this.getPushUrl(), descriptive);
    }

    @Editable(order=1000, name="Fetch URL", description="Specify URL of a git repository to fetch changes from, for example:<em>http://scm-host:8000/repo.git</em>")
    @NotEmpty
    @ScriptApi(value="Get URL of the repository to pull changes from.")
    @Scriptable
    public String getFetchUrl() {
        return this.fetchUrl;
    }

    public void setFetchUrl(String fetchUrl) {
        this.fetchUrl = fetchUrl;
    }

    @Editable(order=1100, name="Push URL", description="Optionally specify the push url to push tags to remote repository. If blank, the fetch url is used.")
    @ScriptApi(value="Get push url of the remote repository to push tags.")
    @Scriptable
    public String getPushUrl() {
        return this.pushUrl;
    }

    public void setPushUrl(String pushUrl) {
        this.pushUrl = pushUrl;
    }

    @Editable(order=1200, name="User Name", description="Optionally specify the user who has permission to access the above url.")
    @ScriptApi(value="Get the user name used to login the remote repository.")
    @Scriptable
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=1300, description="Specify password of the above user.<br><span class='bold red'>IMPORTANT:</span> For SSH based protocols (ssh, scp, sftp), please do NOT specify password here. You need to use public key authentication without pass phrase instead to avoid hanging. Refer to http://wiki.pmease.com for details.")
    @Password
    @ScriptApi(value="Get password to access the repository. Null if not specified.")
    @Scriptable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=1400, name="Destination Path", description="Specify the destination path to which contents in the above url will be retrieved into. This path is relative to the running configuration's workspace. If left empty, the workspace directory itself will be used to put checked out contents.")
    @ScriptApi(value="Get destination path to put checked out files. Null if workspace directory is used.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(order=1600, name="Committer User Schema", description="Consider author's or committer's name or email as the owner of each changeset.")
    @NotEmpty
    @ChoiceProvider(value="getAllSchema")
    public String getUserSchema() {
        return this.userSchema;
    }

    public void setUserSchema(String userSchema) {
        this.userSchema = userSchema;
    }

    @Editable(order=2000, name="Reference Repo", description="The reference repository used when cloning repo")
    @Scriptable
    @Advanced
    public String getReferenceRepoPath() {
        return this.referenceRepoPath;
    }

    public void setReferenceRepoPath(String referenceRepoPath) {
        this.referenceRepoPath = referenceRepoPath;
    }

    public UserSchema getSchemaValue() {
        return UserSchema.fromDisplayName(this.getUserSchema());
    }

    private static List<String> getAllSchema() {
        ArrayList<String> values = new ArrayList<String>();
        for (UserSchema each : UserSchema.values()) {
            values.add(each.getDisplayName());
        }
        return values;
    }

    @Editable(order=1700, name="Branch Name", description="Optionally specify the branch which you want to pull. If not specified, the 'master' branch will be used. Specifically, if the name contains wildcards, QB will build all branches matching the pattern upon branch update.")
    @ScriptApi(value="Get specified branch to build against.")
    @Scriptable
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getActualBranch() {
        String branch = this.getBranch();
        if (StringUtils.isEmpty((String)branch)) {
            return "master";
        }
        if (!(branch.contains(" ") || branch.contains("*") || branch.contains("?"))) {
            return branch;
        }
        if (this.getBuild().getRequest().getShortBranch() != null) {
            return this.getBuild().getRequest().getShortBranch().getName();
        }
        throw new QuickbuildException("Unable to determine short branch to build against.");
    }

    @Editable(order=1800, name="Commit or Tag to Build", description="Optionally specify commit or tag to build against. If specified, branch information specified above will be ignored; otherwise, tip commit of above branch will be checked out.")
    @ScriptApi(value="Get specified commit or tag to build against. Null to build against tip commit.")
    @Scriptable
    public String getBuildRevision() {
        return this.buildRevision;
    }

    public void setBuildRevision(String buildRevision) {
        this.buildRevision = buildRevision;
    }

    @Editable(order=1900, name="Enable Submodule", description="Tell QuickBuild to update submodules or not. If enabled, QuickBuild will update submodules, otherwise, QuickBuild will ignore the submodules.")
    @ScriptApi(value="Enable submodule or not")
    public boolean isEnableSubmodule() {
        return this.enableSubmodule;
    }

    public void setEnableSubmodule(boolean enableSubmodule) {
        this.enableSubmodule = enableSubmodule;
    }

    public Collection<ShortBranch> getShortBranches() {
        if (this.getBuildRevision() != null) {
            return null;
        }
        String branch = this.getBranch();
        if (branch != null && (branch.contains(" ") || branch.contains("*") || branch.contains("?"))) {
            Commandline cmd = new Commandline(GitRepository.getGitPath());
            String actualUrl = new GitUrl(this.getFetchUrl(), this.getUserName(), this.getPassword()).toString();
            cmd.addArgValue("ls-remote").addArgValue(actualUrl).addArgLine(branch);
            final ArrayList<ShortBranch> shortBranches = new ArrayList<ShortBranch>();
            cmd.execute((OutputStream)new LineConsumer(){

                public void consume(String line) {
                    ShortBranch shortBranch = new ShortBranch();
                    shortBranch.setName(StringUtils.substringAfter((String)line, (String)"\t").trim());
                    shortBranch.setRevision(StringUtils.substringBefore((String)line, (String)"\t").trim());
                    shortBranches.add(shortBranch);
                }
            }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
            return shortBranches;
        }
        return null;
    }

    private GitCli getGit() {
        GitCli gitCli = new GitCli(this);
        String nodeAddress = Grid.instance.getLocalNode().getAddress();
        if (!this.getSyncedNodes().contains(nodeAddress) || !new File(this.getWorkingDir(), DOT_GIT).exists()) {
            gitCli.sync();
            this.getSyncedNodes().add(nodeAddress);
        }
        return gitCli;
    }

    private Set<String> getSyncedNodes() {
        if (this.syncedNodes == null) {
            this.syncedNodes = new HashSet<String>();
        }
        return this.syncedNodes;
    }

    public File dotGit() {
        return new File(this.getWorkingDir(), DOT_GIT);
    }

    public boolean exists() {
        return this.getWorkingDir().exists() && this.dotGit().exists();
    }

    public Properties getCurrentRC() {
        Properties properties = new Properties();
        properties.put(FETCH_URL, this.getActualFetchUrl(false));
        properties.put(PUSH_URL, this.getActualPushUrl(false));
        if (Strings.isNullOrEmpty((String)this.getReferenceRepoPath())) {
            properties.remove(REFERENCE);
        } else {
            properties.put(REFERENCE, this.getReferenceRepoPath());
        }
        return properties;
    }

    @Editable(order=700, description="Check this to enable proof build for this repository.")
    @ScriptApi(value="Get proof build support object. Null if proof build support is not enabled for this repository.")
    @Advanced
    public GitProofBuildSupport getProofBuildSupport() {
        return this.proofBuildSupport;
    }

    public void setProofBuildSupport(GitProofBuildSupport proofBuildSupport) {
        this.proofBuildSupport = proofBuildSupport;
    }

    public static String getGitPath() {
        GitPluginSetting setting = GitPluginSetting.get();
        String path = setting.getGitExePath();
        if (StringUtils.isEmpty((String)path)) {
            return "git";
        }
        return path;
    }

    public String getEmail(String committer) {
        switch (this.getSchemaValue()) {
            case AuthorEmail: 
            case CommitterEmail: {
                return committer;
            }
            case AuthorNameAndEmail: 
            case CommitterNameAndEmail: {
                return (String)CommitterUtils.splitUserAndEmail((String)committer).getSecond();
            }
        }
        return null;
    }

    public String format(String type, Map<String, Object> map) {
        AbstractRepository.FormatType t = AbstractRepository.FormatType.valueOf((String)type);
        String rev = null;
        switch (t) {
            case CHANGEID: {
                rev = (String)map.get("changeId");
                break;
            }
            case EDITION: {
                rev = (String)map.get("edition");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format field type " + type);
            }
        }
        return new GitRevision(rev).toShortId();
    }

    private void migrate1(VersionedDocument vd, Stack<Integer> versions) {
        vd.setValue("referenceRepoPath", "");
    }
}

