/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.git.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.git.GitRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmException;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.wicket.util.io.IOUtils;
import org.hibernate.validator.constraints.NotEmpty;

public class GitProofBuildSupport
extends ProofBuildSupport<LocalChange> {
    private static final long serialVersionUID = 1L;
    private GitRepository repository;
    private String localPath;
    private String changesetNumber;
    private String mergeCondition = "true";
    private String pushCondition = "build.successful";
    @Transient
    private String localHead;

    public GitProofBuildSupport(GitRepository repository) {
        this.repository = repository;
    }

    @Editable(name="Local Repository Path", order=100, description="Specify path to your local Git repository. QuickBuild will send local changes found in this local repository (ie. commits exists in local branch but not available in remote branch) to run proof build.<br><span class='bold red'>IMPORTANT:</span> The remote named 'origin' of this local repository must correspond to the remote repository defined above. Also the push and fetch operation in this local repository should not prompt for any user name or password.")
    @Scriptable
    @ScriptApi(value="Get path to local Git repository. Will not be null.")
    @NotEmpty
    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Editable(name="Change Set Number", order=200, description="Optionally specify a local change set number or revision for proof build. All ancestor change sets of specified change set will also be verified. If left empty, all outgoing change sets will be verified.")
    @ScriptApi(value="Get change set number for proof build. Null if not specified.")
    @Scriptable
    public String getChangesetNumber() {
        return this.changesetNumber;
    }

    public void setChangesetNumber(String changesetNumber) {
        this.changesetNumber = changesetNumber;
    }

    @Editable(name="Merge Condition", order=400, description="This condition only takes effect when change set number is not specified above, and can make proof build more accurate when dealing with pushed changes of other developers. If satisfied, QuickBuild will pull incoming changes from this repository to merge with the local repository before collecting outgoing change sets.")
    @Expressions(value={"always merge", "true", "do not merge", "false"})
    @ScriptApi(value="Get merge condition. Will not be null.")
    @Scriptable
    @NotEmpty
    public String getMergeCondition() {
        return this.mergeCondition;
    }

    public void setMergeCondition(String mergeCondition) {
        this.mergeCondition = mergeCondition;
    }

    @Editable(name="Push Condition", order=500, description="Specify the condition to push verified outgoing change sets. If this condition is satisfied, outgoing change sets specified above will be pushed to this repository after the build finishes.")
    @Expressions(value={"push only when build is successful", "build.successful", "always push", "true", "do not push", "false"})
    @Scriptable
    @ScriptApi(value="Get push condition. Will not be null.")
    @NotEmpty
    public String getPushCondition() {
        return this.pushCondition;
    }

    public void setPushCondition(String pushCondition) {
        this.pushCondition = pushCondition;
    }

    @ScriptApi(value="Get repository object.")
    public GitRepository getRepository() {
        return this.repository;
    }

    public void buildFinished() {
        ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
        if (((Boolean)scriptEngine.evaluate(this.getPushCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
            if (this.getChangesetNumber() != null) {
                Context.getLogger().info("Pushing local change sets...");
                Commandline cmd = this.buildGitCmd().addArgLine("push origin").addArgValue(this.getChangesetNumber() + ":" + this.repository.getActualBranch());
                cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), new LineConsumer(){

                    public void consume(String line) {
                        if (line.startsWith("Compressing objects:") || line.startsWith("Writing objects:")) {
                            Context.getLogger().debug(line);
                        } else if (line.startsWith("warning:")) {
                            Context.getLogger().warn(StringUtils.substringAfter((String)line, (String)" "));
                        } else {
                            Context.getLogger().info(line);
                        }
                    }
                }).checkReturnCode();
            } else {
                Context.getLogger().info("No local change sets to push.");
            }
        }
    }

    public File getCheckoutFile(String repositoryPath) {
        return new File(this.repository.getWorkingDir(), repositoryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChange getLocalChange(File changeStoreDir) {
        Commandline cmd = this.buildGitCmd().addArgLine("rev-parse HEAD");
        Context.getLogger().info("Checking working head...");
        cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

            public void consume(String line) {
                GitProofBuildSupport.this.localHead = line;
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        Class<GitRepository> clazz = GitRepository.class;
        synchronized (GitRepository.class) {
            String untilCommit;
            cmd = this.buildGitCmd().addArgLine("config core.quotepath false");
            cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this.getChangesetNumber() == null) {
                ScriptEngine scriptEngine = (ScriptEngine)Quickbuild.getInstance(ScriptEngine.class);
                if (((Boolean)scriptEngine.evaluate(this.getMergeCondition(), Context.buildEvalContext((Object)((Object)this), null))).booleanValue()) {
                    cmd = this.buildGitCmd().addArgValue("status");
                    Context.getLogger().info("Checking if there are uncommitted files...");
                    final boolean[] commitClean = new boolean[]{false};
                    final boolean[] commitFound = new boolean[]{false};
                    Commandline.ExecuteResult result = cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                        public void consume(String line) {
                            Context.getLogger().info(line);
                            if (line.startsWith("nothing to commit")) {
                                commitClean[0] = true;
                            } else if (line.startsWith("# Changes to be committed:")) {
                                commitFound[0] = true;
                            } else if (line.startsWith("# Changed but not updated:")) {
                                commitFound[0] = true;
                            } else if (line.startsWith("# Unmerged paths:")) {
                                commitFound[0] = true;
                            }
                        }
                    }, (LineConsumer)new LineConsumer.ErrorLogger());
                    if (commitFound[0]) {
                        throw new ScmException("QuickBuild can not proceed to merge with others' changes as there are uncommitted files in your working directory.");
                    }
                    if (result.getReturnCode() != 0 && !commitClean[0]) {
                        throw result.buildException();
                    }
                    cmd = this.buildGitCmd().addArgLine("fetch origin").addArgValue(this.repository.getActualBranch());
                    Context.getLogger().info("Fetching remote change sets...");
                    cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer.InfoLogger(), (LineConsumer)new LineConsumer.InfoLogger()).checkReturnCode();
                    cmd = this.buildGitCmd().addArgLine("merge FETCH_HEAD");
                    Context.getLogger().info("Merging with FETCH_HEAD...");
                    final boolean[] conflictsFound = new boolean[]{false};
                    result = cmd.execute(this.getWorkingDir(), (OutputStream)new LineConsumer(){

                        public void consume(String line) {
                            Context.getLogger().info(line);
                            if (line.startsWith("Automatic merge failed;")) {
                                conflictsFound[0] = true;
                            }
                        }
                    }, (LineConsumer)new LineConsumer.ErrorLogger());
                    if (conflictsFound[0]) {
                        throw new ScmException("Merge conflicts found. Please fix conflicts and merge first, then run proof build again.");
                    }
                    result.checkReturnCode();
                }
                untilCommit = this.localHead;
            } else {
                untilCommit = this.getChangesetNumber();
            }
            return this.getLocalChange(changeStoreDir, this.getWorkingDir(), "origin/" + this.repository.getActualBranch(), untilCommit, false);
        }
    }

    private LocalChange getLocalChange(File changeStoreDir, File workingDir, String sinceCommit, String untilCommit, final boolean forSubmodule) {
        Context.getLogger().info("Checking local change sets in working directory: " + workingDir.getAbsolutePath());
        Commandline logCmd = this.buildGitCmd().addArgLine("log --name-status --pretty=raw --reverse");
        logCmd.addArgValue(sinceCommit + ".." + untilCommit);
        final ChangeLogConsumer consumer = new ChangeLogConsumer(this.repository.getSchemaValue());
        logCmd.execute(workingDir, (OutputStream)new LineConsumer("UTF-8"){

            public void consume(String line) {
                Context.getLogger().info(line);
                consumer.consume(line);
                if (!forSubmodule && line.startsWith("commit ")) {
                    GitProofBuildSupport.this.setChangesetNumber(StringUtils.substringAfter((String)line, (String)" "));
                    GitProofBuildSupport.this.getRepository().setDirty(true);
                }
            }
        }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
        List<Changeset> changes = consumer.getChanges();
        ArrayList mergedModifications = new ArrayList();
        for (Changeset each : changes) {
            Modification.merge(mergedModifications, (List)each.getModifications());
        }
        LocalChange localChange = new LocalChange();
        for (Modification each : mergedModifications) {
            String path = each.getPath();
            if (each.getAction() == Modification.Action.DELETE) {
                localChange.getDeletePaths().add(path);
                continue;
            }
            Commandline cmd = this.buildGitCmd().addArgValue("ls-tree").addArgValue(untilCommit).addArgValue(path);
            final AtomicReference<Object> submoduleUntilCommit = new AtomicReference<Object>(null);
            cmd.execute(workingDir, (OutputStream)new LineConsumer(){

                public void consume(String line) {
                    if (StringUtils.isNotBlank((String)line)) {
                        StringTokenizer tokenizer = new StringTokenizer(line);
                        tokenizer.nextToken();
                        if (tokenizer.nextToken().equals("commit")) {
                            submoduleUntilCommit.set(tokenizer.nextToken());
                        }
                    }
                }
            }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            if (submoduleUntilCommit.get() != null) {
                LocalChange submoduleChange;
                cmd = this.buildGitCmd().addArgValue("ls-tree").addArgValue(sinceCommit).addArgValue(path);
                final AtomicReference<Object> submoduleSinceCommit = new AtomicReference<Object>(null);
                cmd.execute(workingDir, (OutputStream)new LineConsumer(){

                    public void consume(String line) {
                        if (StringUtils.isNotBlank((String)line)) {
                            StringTokenizer tokenizer = new StringTokenizer(line);
                            tokenizer.nextToken();
                            if (tokenizer.nextToken().equals("commit")) {
                                submoduleSinceCommit.set(tokenizer.nextToken());
                            }
                        }
                    }
                }, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
                File submoduleDir = new File(workingDir, path);
                File submoduleChangeStoreDir = new File(changeStoreDir, path);
                if (submoduleSinceCommit.get() != null) {
                    submoduleChange = this.getLocalChange(submoduleChangeStoreDir, submoduleDir, submoduleSinceCommit.get(), submoduleUntilCommit.get(), true);
                } else {
                    submoduleChange = new LocalChange();
                    Stack<File> descendents = new Stack<File>();
                    descendents.addAll(Arrays.asList(submoduleDir.listFiles()));
                    while (!descendents.isEmpty()) {
                        File childFile = (File)descendents.pop();
                        if (childFile.getName().equals(".git")) continue;
                        String childPath = FileUtils.getRelativePath((String)childFile.getAbsolutePath(), (String)submoduleDir.getAbsolutePath());
                        submoduleChange.getAddPaths().add(childPath);
                        if (childFile.isFile()) {
                            FileUtils.copyFile((File)childFile, (File)submoduleChange.getStoredFile(submoduleChangeStoreDir, childPath));
                            continue;
                        }
                        FileUtils.createDir((File)submoduleChange.getStoredFile(submoduleChangeStoreDir, childPath));
                        descendents.addAll(Arrays.asList(childFile.listFiles()));
                    }
                }
                for (String addPath : submoduleChange.getAddPaths()) {
                    localChange.getAddPaths().add(path + "/" + addPath);
                }
                for (String modifyPath : submoduleChange.getModifyPaths()) {
                    localChange.getModifyPaths().add(path + "/" + modifyPath);
                }
                for (String deletePath : submoduleChange.getDeletePaths()) {
                    localChange.getDeletePaths().add(path + "/" + deletePath);
                }
                continue;
            }
            if (each.getAction() == Modification.Action.ADD) {
                localChange.getAddPaths().add(path);
            } else {
                localChange.getModifyPaths().add(path);
            }
            File destFile = new File(changeStoreDir, path);
            FileUtils.createDir((File)destFile.getParentFile());
            cmd = this.buildGitCmd().addArgValue("show");
            if (!forSubmodule) {
                Validate.notNull((Object)this.getChangesetNumber());
                cmd.addArgValue(this.getChangesetNumber() + ":" + path);
            } else {
                cmd.addArgValue(untilCommit + ":" + path);
            }
            Context.getLogger().debug("Reading content of path: " + path);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(destFile);
                cmd.execute(workingDir, (OutputStream)os, (LineConsumer)new LineConsumer.ErrorLogger()).checkReturnCode();
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)os);
        }
        return localChange;
    }

    private File getWorkingDir() {
        return new File(this.getLocalPath());
    }

    private Commandline buildGitCmd() {
        return new Commandline().setExecutable(GitRepository.getGitPath());
    }
}

