/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.execution.SecretMasker;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.plugin.scm.git.ChangeLogConsumer;
import com.pmease.quickbuild.plugin.scm.git.GitCommand;
import com.pmease.quickbuild.plugin.scm.git.GitRepository;
import com.pmease.quickbuild.plugin.scm.git.GitRevision;
import com.pmease.quickbuild.plugin.scm.helper.AbstractRepository;
import com.pmease.quickbuild.plugin.scm.helper.ScmCli;
import com.pmease.quickbuild.plugin.scm.helper.consumer.LineListConsumer;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.RevisionInfo;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GitCli
extends ScmCli<GitCli, GitRepository, GitCommand> {
    public GitCli(GitRepository repository) {
        super((AbstractRepository)repository, "UTF-8");
    }

    static String parseHash(String hash) {
        return "0000000000000000000000000000000000000000".equals(hash) ? null : hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSync() {
        if (this.getRepository().exists()) {
            this.fetch();
        } else {
            try {
                FileUtils.deleteDir((File)this.getWorkingDir());
                this.create().fetch();
            }
            finally {
                this.getRepository().saveRC();
            }
        }
    }

    public RevisionInfo getRevisionInfo(GitRevision revision) {
        final RevisionInfo info = new RevisionInfo();
        GitCommand cmd = this.createCommand();
        cmd.addArgLine("show --quiet " + revision.getValue());
        this.run(cmd, new LineConsumer(){

            public void consume(String line) {
                if (line.startsWith("Author:")) {
                    line = line.substring("Author:".length());
                    info.setCommitter(StringUtils.substringBefore((String)line, (String)"<").trim());
                } else if (line.startsWith("    ")) {
                    if (info.getComment() != null) {
                        info.setComment(info.getComment() + "\n" + line.substring(4));
                    } else {
                        info.setComment(line.substring(4));
                    }
                }
            }
        });
        return info;
    }

    protected GitCommand createCommand() {
        GitCommand cmd = new GitCommand(this.getRepository());
        cmd.setSecretMasker(new SecretMasker(){

            public String mask(String message) {
                if (GitCli.this.getRepository().getPassword() != null) {
                    return StringUtils.replace((String)message, (String)(":" + GitCli.this.getRepository().getPassword() + "@"), (String)":******@");
                }
                return message;
            }
        });
        return cmd;
    }

    public GitCli create() {
        File workingDir = this.getWorkingDir();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating git repository to directory [" + workingDir + "] ...");
        }
        FileUtils.createDir((File)workingDir);
        GitCommand command = this.createCommand();
        command.setLine("clone --no-checkout");
        String refRepoPath = ((GitRepository)this.repository).getReferenceRepoPath();
        if (!Strings.isNullOrEmpty((String)refRepoPath)) {
            File refRepo = new File(refRepoPath);
            if (!refRepo.exists()) {
                throw new QuickbuildException("Reference repository path [" + refRepoPath + "] doesn't exist");
            }
            if (!refRepo.isDirectory()) {
                throw new QuickbuildException("Reference repository path [" + refRepoPath + "] should be a git directory");
            }
            command.setLine("--reference").setValue(refRepoPath);
        }
        if (this.getRepository().isEnableSubmodule()) {
            command.setLine("--recursive");
        }
        command.setValue(this.getRepository().getActualFetchUrl(false), this.getRepository().getActualFetchUrl(true));
        command.setValue(workingDir.getAbsolutePath());
        command.quiet();
        this.run(command, (LineConsumer)new LineConsumer.DebugLogger(this.encoding));
        return this;
    }

    public GitCli fetch() {
        GitCommand command = (GitCommand)this.buildCommand("fetch");
        command.addArgValue("--all");
        command.quiet();
        this.run(command, (LineConsumer)new LineConsumer.DebugLogger(this.encoding), (LineConsumer)new LineConsumer.ErrorLogger(this.encoding));
        if (this.getRepository().getBuildRevision() == null) {
            command = (GitCommand)this.buildCommand("fetch");
            command.addArgLine("origin").addArgValue(this.getRepository().getActualBranch());
            command.quiet();
            this.run(command, (LineConsumer)new LineConsumer.DebugLogger(this.encoding), (LineConsumer)new LineConsumer.ErrorLogger(this.encoding));
        }
        return this;
    }

    public GitCli merge(String revspec) {
        return (GitCli)this.run(this.buildCommand("merge", revspec), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli push(String refspec) {
        GitCommand command = this.createCommand();
        command.setLine("push").setValue(this.getRepository().getActualPushUrl(false), this.getRepository().getActualPushUrl(true));
        if (!StringUtils.isEmpty((String)refspec)) {
            command.setValue(refspec);
        }
        command.quiet();
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding), (LineConsumer)new LineConsumer.WarnLogger(this.encoding));
    }

    public GitCli checkout(String refspec) {
        return ((GitCli)this.run(((GitCommand)this.buildCommand("checkout -f ", refspec)).quiet(), (LineConsumer)new LineConsumer.DebugLogger(this.encoding), new LineConsumer(this.encoding){

            public void consume(String line) {
                if (line.startsWith("HEAD is now at")) {
                    Context.getLogger().info(line);
                } else {
                    Context.getLogger().warn(line);
                }
            }
        })).updateSubmodules();
    }

    public GitCli commit(String comment) {
        GitCommand command = this.createCommand();
        command.setLine("commit -a -m").setValue(comment);
        command.quiet();
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding), (LineConsumer)new LineConsumer.WarnLogger(this.encoding));
    }

    public GitCli switchToHead(String branch) {
        GitCommand command = this.createCommand();
        command.setLine("checkout").setValue(branch);
        command.quiet();
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding), (LineConsumer)new LineConsumer.WarnLogger(this.encoding));
    }

    public GitCli clean() {
        return (GitCli)this.run(((GitCommand)this.buildCommand("clean -fdx")).quiet(), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli updateSubmodules() {
        if (this.getRepository().isEnableSubmodule()) {
            this.run((GitCommand)((GitCommand)this.buildCommand("submodule")).quiet().addArgLine("update --init --recursive"), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
        }
        return this;
    }

    public GitCli config(String property, String value) {
        return this.config("--replace-all", property, value);
    }

    public GitCli config(String options, String property, String value) {
        GitCommand command = this.createCommand();
        command.setLine("config");
        if (options != null) {
            command.setLine(options);
        }
        command.setValue(property);
        command.setValue(value);
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli tagLocal(GitRevision rev, String tagName, String comment) {
        GitCommand command = this.createCommand();
        command.setLine("tag -a -f -m ");
        String actualComment = StringUtils.isEmpty((String)comment) ? "Tag for revision " + (Object)((Object)rev) : comment;
        command.setValue(actualComment);
        command.setValue(tagName);
        command.setValue(rev.toString());
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli tagRemote(GitRevision rev, String tagName, String comment) {
        this.tagLocal(rev, tagName, comment);
        GitCommand command = ((GitCommand)this.buildCommand("push --tags")).quiet();
        command.setValue(this.getRepository().getActualPushUrl(false), this.getRepository().getActualPushUrl(true));
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli branchLocal(String branchName, String refspec) {
        GitCommand command = this.createCommand();
        command.setLine("checkout --track -b ");
        command.setValue(branchName);
        command.setValue(refspec);
        return (GitCli)this.run(command, (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli branchRemote(String branchName) {
        return (GitCli)this.run(this.buildCommand("push origin", "origin:refs/heads/" + branchName), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
    }

    public GitCli deleteLocalBranch(String branchName) {
        this.run("checkout master", (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
        this.run(this.buildCommand("branch -d -r ", "origin/" + branchName), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
        this.run(this.buildCommand("branch -D ", branchName), (LineConsumer)new LineConsumer.InfoLogger(this.encoding));
        return this;
    }

    public GitCli deleteRemoteBranch(String branchName) {
        return ((GitCli)this.run(this.buildCommand("push origin ", ":heads/" + branchName), (LineConsumer)new LineConsumer.InfoLogger(this.encoding))).deleteLocalBranch(branchName);
    }

    public GitRevision revision(String refspec) {
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        GitCommand command = (GitCommand)this.buildCommand("log -1 --pretty=format:%H", refspec);
        this.run(command, (LineConsumer)consumer);
        String line = consumer.lastLine().trim();
        return new GitRevision(GitCli.parseHash(line));
    }

    public GitCommand changelogCommand() {
        return (GitCommand)this.buildCommand("log --name-status --pretty=raw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Changeset> changes(String line) {
        Class<GitRepository> clazz = GitRepository.class;
        synchronized (GitRepository.class) {
            this.config("core.quotepath", "false");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            GitCommand command = this.changelogCommand();
            command.addArgLine(line);
            ChangeLogConsumer consumer = new ChangeLogConsumer(this.getRepository().getSchemaValue());
            this.run(command, consumer);
            return consumer.getChanges();
        }
    }

    private Date getDateOfRevision(String rev, boolean useCommitDate) {
        if (StringUtils.isEmpty((String)rev)) {
            return INVALID_DATE;
        }
        LineListConsumer consumer = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        GitCommand command = (GitCommand)this.buildCommand("log -1 --date=raw");
        if (useCommitDate) {
            command.setValue("--pretty=format:%cd");
        } else {
            command.setValue("--pretty=format:%ad");
        }
        command.setValue(rev);
        this.run(command, (LineConsumer)consumer);
        String line = consumer.getContent().trim();
        String[] tokens = StringUtils.split((String)line);
        if (tokens.length == 0) {
            return INVALID_DATE;
        }
        return GitCli.parseDate(tokens[0]);
    }

    public List<Changeset> changesBetween(GitRevision from, GitRevision to) {
        Date fromDate = this.getDateOfRevision(from.toString(), true);
        Date toDate = this.getDateOfRevision(to.toString(), true);
        if (fromDate.getTime() > toDate.getTime()) {
            this.getLogger().warn("The start revision [" + (Object)((Object)from) + "] seems elder than end revision [" + (Object)((Object)to) + "].");
        }
        String revspec = "";
        if (from != null) {
            revspec = from.toString();
        }
        revspec = revspec + "..";
        if (to != null) {
            revspec = revspec + to.toString();
        }
        return this.changes(revspec);
    }

    public List<String> show(String path, GitRevision rev) {
        if (!this.getRepository().exists()) {
            this.getLogger().error("Failed to read file '" + path + "' due to local repository does not exist.");
            return null;
        }
        LineListConsumer handler = new LineListConsumer(Log.LogLevel.DEBUG, this.encoding);
        GitCommand command = (GitCommand)this.buildCommand("show", (Object)((Object)rev) + ":" + path);
        this.run(command, (LineConsumer)handler);
        return handler.getLines();
    }

    public static Date parseDate(String timeInSeconds) {
        Long mils = Long.parseLong(timeInSeconds.trim()) * 1000L;
        return new Date(mils);
    }

    public GitRepository getRepository() {
        return (GitRepository)super.getRepository();
    }

    public static void main(String[] args) {
        Date china = GitCli.parseDate("1369455338");
        Date german = GitCli.parseDate("1369455416");
        System.out.println(china.getTime() < german.getTime());
    }
}

