/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.scm.git;

import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.plugin.scm.git.PersonIdent;
import com.pmease.quickbuild.plugin.scm.git.UserSchema;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ChangeLogConsumer
extends LineConsumer {
    private static final Pattern AUTHOR_ENTRY = Pattern.compile("^author (.*) <(.*)> (.*) (.*)$");
    private static final Pattern COMMITTER_ENTRY = Pattern.compile("^committer (.*) <(.*)> (.*) (.*)$");
    private static final Pattern MODIFICATION_ENTRY = Pattern.compile("^([ACDMRTUX])[0-9]*\\t(.*)$");
    private List<Changeset> changes = new ArrayList<Changeset>();
    private Changeset current;
    private String parentId;
    private PersonIdent author;
    private PersonIdent committer;
    private final UserSchema schema;

    static LogStatus getStatus(String line) {
        if (line.startsWith("commit ")) {
            return LogStatus.COMMIT;
        }
        if (line.startsWith("tree ")) {
            return LogStatus.TREE;
        }
        if (line.startsWith("parent ")) {
            return LogStatus.PARENT;
        }
        if (line.startsWith("author ")) {
            return LogStatus.AUTHOR;
        }
        if (line.startsWith("committer ")) {
            return LogStatus.COMMITTER;
        }
        if (line.startsWith("    ")) {
            return LogStatus.MESSAGE;
        }
        Matcher m = MODIFICATION_ENTRY.matcher(line);
        if (m.matches() && m.groupCount() >= 2) {
            return LogStatus.MODIFICATION;
        }
        return LogStatus.UNKNOWN;
    }

    public ChangeLogConsumer(UserSchema schema) {
        super("UTF-8");
        this.schema = schema;
    }

    protected Changeset createChangeset() {
        return new Changeset();
    }

    protected Modification createModification() {
        return new Modification();
    }

    public void consume(String line) {
        LogStatus status = ChangeLogConsumer.getStatus(line);
        switch (status) {
            case COMMIT: {
                this.current = this.createChangeset();
                this.current.setId(StringUtils.split((String)line)[1]);
                this.changes.add(this.current);
                break;
            }
            case TREE: {
                break;
            }
            case PARENT: {
                this.parentId = StringUtils.split((String)line)[1];
                break;
            }
            case COMMITTER: {
                Matcher cm;
                if (UserSchema.useAuthor(this.schema) || !(cm = COMMITTER_ENTRY.matcher(line)).matches() || cm.groupCount() < 4) break;
                this.committer = new PersonIdent(cm.group(1), cm.group(2), cm.group(3), cm.group(4));
                if (this.schema == UserSchema.CommitterName) {
                    this.current.setUser(this.committer.getName());
                } else if (this.schema == UserSchema.CommitterEmail) {
                    this.current.setUser(this.committer.getEmailAddress());
                } else {
                    this.current.setUser(this.committer.getFullCommitterName());
                }
                this.current.setDate(this.committer.getWhen());
                break;
            }
            case AUTHOR: {
                Matcher am;
                if (!UserSchema.useAuthor(this.schema) || !(am = AUTHOR_ENTRY.matcher(line)).matches() || am.groupCount() < 4) break;
                this.author = new PersonIdent(am.group(1), am.group(2), am.group(3), am.group(4));
                if (this.schema == UserSchema.AuthorName) {
                    this.current.setUser(this.author.getName());
                } else if (this.schema == UserSchema.AuthorEmail) {
                    this.current.setUser(this.author.getEmailAddress());
                } else {
                    this.current.setUser(this.author.getFullCommitterName());
                }
                this.current.setDate(this.author.getWhen());
                break;
            }
            case MESSAGE: {
                String msg = line.substring(4);
                String comment = this.current.getComment();
                comment = comment == null ? msg : comment + "\n" + msg;
                this.current.setComment(comment);
                break;
            }
            case MODIFICATION: {
                Matcher mModification = MODIFICATION_ENTRY.matcher(line);
                if (!mModification.matches() || mModification.groupCount() < 2) break;
                Modification modification = this.createModification();
                modification.setEdition(this.current.getId());
                modification.setPreviousEdition(this.parentId);
                modification.setPath(mModification.group(2));
                modification.setAction(ChangeLogConsumer.getAction(mModification.group(1)));
                this.updateModification(modification);
                this.current.getModifications().add(modification);
                break;
            }
        }
    }

    protected void updateModification(Modification modification) {
    }

    static Modification.Action getAction(String mode) {
        char c = mode.charAt(0);
        if (c == 'A') {
            return Modification.Action.ADD;
        }
        if (c == 'D') {
            return Modification.Action.DELETE;
        }
        return Modification.Action.MODIFY;
    }

    public List<Changeset> getChanges() {
        return this.changes;
    }

    static enum LogStatus {
        COMMIT,
        TREE,
        PARENT,
        AUTHOR,
        COMMITTER,
        MESSAGE,
        MODIFICATION,
        UNKNOWN;

    }
}

